/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.filter;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.filter.DepthItemFilter;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class NodeTypeItemFilter
extends DepthItemFilter {
    private String nodeType;
    private boolean respectSupertype;

    public NodeTypeItemFilter() {
    }

    public NodeTypeItemFilter(String nodeType, boolean respectSupertype, int minDepth, int maxDepth) {
        super(minDepth, maxDepth);
        this.nodeType = nodeType;
        this.respectSupertype = respectSupertype;
    }

    public NodeTypeItemFilter(String nodeType, boolean respectSupertype) {
        this(nodeType, respectSupertype, 0, Integer.MAX_VALUE);
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public void setRespectSupertype(String respectSupertype) {
        this.respectSupertype = Boolean.valueOf(respectSupertype);
    }

    public boolean matches(Item item) throws RepositoryException {
        if (item.isNode()) {
            if (this.respectSupertype) {
                try {
                    return ((Node)item).isNodeType(this.nodeType);
                }
                catch (RepositoryException e) {
                    return false;
                }
            }
            return ((Node)item).getPrimaryNodeType().getName().equals(this.nodeType);
        }
        return false;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        super.dump(ctx, isLast);
        ctx.indent(isLast);
        ctx.printf(false, "nodeType: %s", new Object[]{this.nodeType});
        ctx.printf(true, "respectSupertype: %b", new Object[]{this.respectSupertype});
        ctx.outdent();
    }
}

