/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.filter;

import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.ItemFilter;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class NtFileItemFilter
implements ItemFilter {
    private static final Set<String> fileNames = new HashSet<String>();
    private static final Set<String> resNames;

    public boolean matches(Item item, int depth) throws RepositoryException {
        if (item.isNode()) {
            Node node = (Node)item;
            if (depth == 0) {
                return node.isNodeType("nt:file");
            }
            if (depth == 1) {
                return item.getName().equals("jcr:content");
            }
            return false;
        }
        if (depth == 1) {
            return fileNames.contains(item.getName());
        }
        if (depth == 2 && item.getParent().getName().equals("jcr:content")) {
            return resNames.contains(item.getName());
        }
        return false;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.printf(isLast, "%s:", new Object[]{this.getClass().getSimpleName()});
    }

    static {
        fileNames.add("jcr:primaryType");
        fileNames.add("jcr:mixinTypes");
        fileNames.add("jcr:uuid");
        fileNames.add("jcr:created");
        fileNames.add("jcr:createdBy");
        resNames = new HashSet<String>();
        resNames.add("jcr:encoding");
        resNames.add("jcr:mimeType");
        resNames.add("jcr:primaryType");
        resNames.add("jcr:mixinTypes");
        resNames.add("jcr:uuid");
        resNames.add("jcr:lastModified");
        resNames.add("jcr:data");
    }
}

