/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl;

import com.day.jcr.vault.fs.api.Aggregate;
import com.day.jcr.vault.fs.api.Aggregator;
import com.day.jcr.vault.fs.api.ArtifactSet;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.RepositoryAddress;
import com.day.jcr.vault.fs.impl.AggregateBuilder;
import com.day.jcr.vault.fs.impl.AggregateManagerImpl;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.AggregateWalkListener;
import com.day.jcr.vault.util.ItemNameComparator;
import com.day.jcr.vault.util.PathUtil;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateImpl
implements Aggregate {
    protected static final Logger log = LoggerFactory.getLogger(AggregateImpl.class);
    private final AggregateImpl parent;
    private final String path;
    private final String relPath;
    private final Aggregator aggregator;
    private final AggregateManagerImpl mgr;
    private ArtifactSetImpl artifacts;
    private Set<String> includes = new HashSet<String>();
    private Collection<Property> binaries = new LinkedList<Property>();
    private final Map<String, AggregateImpl> leaves = new LinkedHashMap<String, AggregateImpl>();
    private Map<String, String> namespaces;
    private State state = State.INITIAL;
    private WeakReference<Node> nodeRef;

    protected AggregateImpl(AggregateManagerImpl mgr, String path, Aggregator aggregator) throws RepositoryException {
        log.info("Create Root Aggregate {}", (Object)path);
        this.mgr = mgr;
        this.parent = null;
        this.path = path.equals("/") ? "" : path;
        this.aggregator = aggregator;
        this.relPath = this.path.substring(this.path.lastIndexOf(47) + 1);
    }

    protected AggregateImpl(AggregateImpl parent, String path, Aggregator aggregator) throws RepositoryException {
        log.info("Create Aggregate {}", (Object)path);
        this.mgr = parent.mgr;
        this.parent = parent;
        this.path = path;
        this.aggregator = aggregator;
        this.relPath = path.substring(parent.getPath().length() + 1);
        if (aggregator.hasFullCoverage()) {
            this.state = State.COLLECTED;
        }
    }

    public Node getNode() throws RepositoryException {
        Node node;
        if (this.path.length() == 0) {
            return this.mgr.getSession().getRootNode();
        }
        Node node2 = node = this.nodeRef == null ? null : (Node)this.nodeRef.get();
        if (node == null) {
            node = (Node)this.mgr.getSession().getItem(this.path);
            this.nodeRef = new WeakReference<Node>(node);
        }
        return node;
    }

    public boolean hasNode() throws RepositoryException {
        return this.path.length() == 0 || this.mgr.getSession().itemExists(this.path);
    }

    public void invalidate() {
        log.info("invalidating aggregate {}", (Object)this.getPath());
        this.artifacts = null;
        this.includes.clear();
        this.binaries.clear();
        this.leaves.clear();
        this.namespaces = null;
        this.nodeRef = null;
        this.state = State.INITIAL;
    }

    public Aggregate getParent() {
        return this.parent;
    }

    public String getPath() {
        return this.path;
    }

    public RepositoryAddress getRepositoryAddress() throws RepositoryException {
        return this.mgr.getMountpoint().resolve(this.path);
    }

    public boolean allowsChildren() {
        return this.aggregator == null || !this.aggregator.hasFullCoverage();
    }

    public String getRelPath() {
        return this.relPath;
    }

    public String getName() {
        return this.relPath.substring(this.relPath.lastIndexOf(47) + 1);
    }

    public Map<String, ? extends Aggregate> getLeaves() throws RepositoryException {
        this.load();
        return this.leaves;
    }

    public Aggregate getAggregate(String relPath) throws RepositoryException {
        String[] pathElems = PathUtil.makePath((String[])null, (String)relPath);
        if (pathElems == null) {
            return this;
        }
        return this.getAggregate(pathElems, 0);
    }

    private Aggregate getAggregate(String[] pathElems, int pos) throws RepositoryException {
        if (pos < pathElems.length) {
            String elem = pathElems[pos];
            if (elem.equals("..")) {
                return this.parent == null ? null : this.parent.getAggregate(pathElems, pos + 1);
            }
            this.load();
            for (AggregateImpl a : this.leaves.values()) {
                int i;
                String[] le = Text.explode((String)a.relPath, (int)47);
                for (i = 0; i < le.length && i + pos < pathElems.length && le[i].equals(pathElems[i + pos]); ++i) {
                }
                if (i != le.length) continue;
                return a.getAggregate(pathElems, i + pos);
            }
            return null;
        }
        return this;
    }

    public ArtifactSet getArtifacts() throws RepositoryException {
        if (this.artifacts == null) {
            this.assertAttached();
            this.load();
            this.artifacts = (ArtifactSetImpl)this.aggregator.createArtifacts((Aggregate)this);
        }
        return this.artifacts;
    }

    public AggregateBuilder getBuilder() throws RepositoryException {
        this.assertAttached();
        return new AggregateBuilder(this, this.getArtifacts());
    }

    public AggregateBuilder create(String reposName) throws RepositoryException {
        this.assertAttached();
        if (!this.allowsChildren()) {
            throw new RepositoryException("Unable to create artifact node below a non-folder.");
        }
        return new AggregateBuilder(this, reposName);
    }

    public ImportInfo remove(boolean recursive) throws RepositoryException {
        this.assertAttached();
        Node node = this.getNode();
        ImportInfo info = this.aggregator.remove(node, recursive, true);
        if (this.parent != null) {
            this.parent.invalidate();
        }
        return info;
    }

    public AggregateManagerImpl getManager() {
        return this.mgr;
    }

    Aggregator getAggregator() {
        return this.aggregator;
    }

    ImportInfo writeArtifacts(ArtifactSetImpl artifacts, String reposName) throws RepositoryException, IOException {
        try {
            return this.mgr.writeAggregate(this, reposName, artifacts);
        }
        catch (RepositoryException e) {
            log.error("Error while writing artifacts of {}: {}", (Object)this.getPath(), (Object)e.toString());
            throw e;
        }
        catch (IOException e) {
            log.error("Error while writing artifacts of {}: {}", (Object)this.getPath(), (Object)e.toString());
            throw e;
        }
    }

    private void assertAttached() throws RepositoryException {
        if (this.aggregator == null || !this.hasNode()) {
            throw new RepositoryException("aggregate not attached anymore");
        }
    }

    public boolean isAttached() throws RepositoryException {
        return this.aggregator != null && this.hasNode();
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "Aggregate");
        ctx.indent(isLast);
        ctx.printf(false, "path: %s", new Object[]{this.getPath()});
        ctx.printf(false, "name: %s", new Object[]{this.getName()});
        ctx.printf(false, "relPath: %s", new Object[]{this.getRelPath()});
        try {
            this.getArtifacts().dump(ctx, false);
        }
        catch (RepositoryException e) {
            ctx.printf(false, "no artifacts: %s", new Object[]{e.toString()});
        }
        ctx.println(false, "Namespaces");
        ctx.indent(false);
        String[] ns = this.getNamespaceURIs();
        for (int i = 0; i < ns.length; ++i) {
            String uri = ns[i];
            String pfx = this.getNamespacePrefix(uri);
            ctx.printf(i == ns.length - 1, "%s = %s", new Object[]{pfx, uri});
        }
        ctx.outdent();
        if (this.aggregator != null) {
            this.aggregator.dump(ctx, true);
        } else {
            ctx.println(true, "no aggregator");
        }
        ctx.outdent();
    }

    public String[] getNamespaceURIs() {
        if (this.namespaces == null) {
            this.loadNamespaces();
        }
        return this.namespaces.keySet().toArray(new String[this.namespaces.keySet().size()]);
    }

    public String getNamespacePrefix(String uri) {
        if (this.namespaces == null) {
            this.loadNamespaces();
        }
        return this.namespaces.get(uri);
    }

    public Collection<Property> getBinaries() {
        return this.binaries;
    }

    public void walk(AggregateWalkListener aggregateWalkListener) throws RepositoryException {
        Node node = this.getNode();
        aggregateWalkListener.onWalkBegin(node);
        this.walk(aggregateWalkListener, node, 0);
        aggregateWalkListener.onWalkEnd(node);
    }

    private void walk(AggregateWalkListener aggregateWalkListener, Node node, int depth) throws RepositoryException {
        if (node != null) {
            boolean included = this.includes((Item)node);
            aggregateWalkListener.onNodeBegin(node, included, depth);
            PropertyIterator piter = node.getProperties();
            while (piter.hasNext()) {
                Property prop = piter.nextProperty();
                if (!this.includes((Item)prop)) continue;
                aggregateWalkListener.onProperty(prop, depth + 1);
            }
            aggregateWalkListener.onChildren(node, depth);
            NodeIterator niter = node.getNodes();
            long size = niter.getSize();
            ArrayList<Node> nodes = new ArrayList<Node>(size > 0L ? (int)size : 16);
            while (niter.hasNext()) {
                nodes.add(niter.nextNode());
            }
            if (!node.getPrimaryNodeType().hasOrderableChildNodes()) {
                Collections.sort(nodes, new ItemNameComparator());
            }
            boolean hasOrderableChildNodes = node.getPrimaryNodeType().hasOrderableChildNodes();
            for (Node child : nodes) {
                if (this.includes((Item)child)) {
                    this.walk(aggregateWalkListener, child, depth + 1);
                    continue;
                }
                if (!hasOrderableChildNodes) continue;
                aggregateWalkListener.onNodeIgnored(child, depth + 1);
            }
            aggregateWalkListener.onNodeEnd(node, included, depth);
        }
    }

    public boolean includes(Item i) throws RepositoryException {
        return this.aggregator.hasFullCoverage() || this.includes.contains(i.getPath());
    }

    private void include(Node node) throws RepositoryException {
        String path = node.getPath();
        if (!this.includes.contains(path)) {
            log.debug("including {} -> {}", (Object)this.getPath(), (Object)path);
            this.includes.add(path);
            this.addNamespace(node.getSession(), node.getName());
            if (!node.isSame((Item)this.getNode())) {
                this.include(node.getParent());
            }
        }
    }

    private void addNamespace(Property prop) throws RepositoryException {
        String propName = prop.getName();
        this.addNamespace(prop.getSession(), propName);
        switch (prop.getType()) {
            case 7: {
                if (propName.equals("jcr:mixinTypes") || prop.getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value value : values = prop.getValues()) {
                        this.addNamespace(prop.getSession(), value.getString());
                    }
                    break;
                }
                this.addNamespace(prop.getSession(), prop.getValue().getString());
                break;
            }
            case 8: {
                if (prop.getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value value : values = prop.getValues()) {
                        this.addNamespacePath(prop.getSession(), value.getString());
                    }
                    break;
                }
                this.addNamespacePath(prop.getSession(), prop.getValue().getString());
            }
        }
    }

    private void include(Node parent, Property prop) throws RepositoryException {
        String path = prop.getPath();
        if (!this.includes.contains(path)) {
            log.debug("including {} -> {}", (Object)this.getPath(), (Object)path);
            this.include(parent);
            this.includes.add(path);
            this.addNamespace(prop);
            if (prop.getType() == 2) {
                this.binaries.add(prop);
            }
        }
    }

    private void addNamespace(Session s, String name) throws RepositoryException {
        int idx = name.indexOf(58);
        if (idx > 0) {
            String prefix = name.substring(0, idx);
            String uri = s.getNamespaceURI(prefix);
            if (this.namespaces == null) {
                this.namespaces = new HashMap<String, String>();
            }
            this.namespaces.put(uri, prefix);
        }
    }

    private void addNamespacePath(Session s, String path) throws RepositoryException {
        String[] names;
        for (String name : names = path.split("/")) {
            this.addNamespace(s, name);
        }
    }

    private void loadNamespaces() {
        if (this.namespaces == null) {
            log.debug("loading namespaces of aggregate {}", (Object)this.getPath());
            try {
                this.load();
                if (this.namespaces == null) {
                    this.namespaces = new HashMap<String, String>();
                }
                if (this.aggregator.hasFullCoverage()) {
                    this.loadNamespaces(this.getNode());
                }
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Internal error while loading namespaces", e);
            }
        }
    }

    private void loadNamespaces(Node node) throws RepositoryException {
        this.addNamespace(node.getSession(), node.getName());
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            this.addNamespace(iter.nextProperty());
        }
        iter = node.getNodes();
        while (iter.hasNext()) {
            this.loadNamespaces(iter.nextNode());
        }
    }

    private void load() throws RepositoryException {
        long now = System.currentTimeMillis();
        if (this.state == State.INITIAL) {
            log.info("Collect + Preparing {}", (Object)this.getPath());
            this.prepare(this.getNode(), true);
            this.state = State.PREPARED;
            long end = System.currentTimeMillis();
            log.info("Collect + Preparing {} in {}ms", (Object)this.getPath(), (Object)(end - now));
        } else if (this.state == State.COLLECTED) {
            log.info("Preparing {}", (Object)this.getPath());
            for (AggregateImpl leaf : this.leaves.values()) {
                leaf.collect();
            }
            this.state = State.PREPARED;
            long end = System.currentTimeMillis();
            log.info("Preparing {} in {}ms", (Object)this.getPath(), (Object)(end - now));
        }
    }

    private void collect() throws RepositoryException {
        if (this.state == State.INITIAL) {
            long now = System.currentTimeMillis();
            log.info("Collecting {}", (Object)this.getPath());
            this.prepare(this.getNode(), false);
            this.state = State.COLLECTED;
            long end = System.currentTimeMillis();
            log.info("Collecting  {} in {}ms", (Object)this.getPath(), (Object)(end - now));
        }
    }

    private void prepare(Node node, boolean descend) throws RepositoryException {
        log.debug("descending into {} (descend={})", (Object)node.getPath(), (Object)descend);
        PropertyIterator pIter = node.getProperties();
        while (pIter.hasNext()) {
            Property p = pIter.nextProperty();
            if (!this.aggregator.includes(this.getNode(), node, p)) continue;
            this.include(node, p);
        }
        NodeIterator nIter = node.getNodes();
        while (nIter.hasNext()) {
            Node n = nIter.nextNode();
            String path = n.getPath();
            boolean isCovered = this.mgr.getWorkspaceFilter().covers(path);
            boolean isAncestor = this.mgr.getWorkspaceFilter().isAncestor(path);
            boolean isIncluded = this.mgr.getWorkspaceFilter().contains(path);
            if (!isCovered && !isAncestor) continue;
            this.addNamespace(n.getSession(), n.getName());
            Aggregator a = this.mgr.getAggregator(n);
            if (a == null || (a == this.aggregator || a.isDefault()) && this.aggregator.includes(this.getNode(), n)) {
                if (!isIncluded && !isAncestor) continue;
                this.include(n);
                this.prepare(n, true);
                continue;
            }
            if (!isAncestor && !isIncluded) continue;
            AggregateImpl sub = new AggregateImpl(this, path, a);
            this.leaves.put(path, sub);
            if (descend) {
                try {
                    sub.collect();
                }
                catch (RepositoryException e) {
                    log.warn("Alledged node is gone: {}", (Object)path);
                    this.leaves.remove(path);
                }
                continue;
            }
            log.debug("adding pending leaf {}", (Object)path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INITIAL,
        COLLECTED,
        PREPARED;

    }
}

