/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl;

import com.day.jcr.vault.fs.api.Aggregate;
import com.day.jcr.vault.fs.api.AggregateManager;
import com.day.jcr.vault.fs.api.Aggregator;
import com.day.jcr.vault.fs.api.ArtifactHandler;
import com.day.jcr.vault.fs.api.ArtifactSet;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.RepositoryAddress;
import com.day.jcr.vault.fs.api.VaultFsConfig;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.config.AbstractVaultFsConfig;
import com.day.jcr.vault.fs.config.ConfigurationException;
import com.day.jcr.vault.fs.config.DefaultWorkspaceFilter;
import com.day.jcr.vault.fs.impl.AggregateImpl;
import com.day.jcr.vault.fs.impl.AggregatorProvider;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.aggregator.RootAggregator;
import com.day.jcr.vault.fs.nodetype.CNDReader;
import com.day.jcr.vault.fs.nodetype.NodeTypeHandling;
import com.day.jcr.vault.fs.nodetype.NodeTypeInstaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateManagerImpl
implements AggregateManager {
    private static final String DEFAULT_CONFIG = "com/day/jcr/vault/fs/config/defaultConfig-1.1.xml";
    private static final String DEFAULT_WSP_FILTER = "com/day/jcr/vault/fs/config/defaultFilter-1.0.xml";
    private static final String DEFAULT_NODETYPES = "com/day/jcr/vault/fs/config/nodetypes.cnd";
    private Session session;
    private final boolean ownSession;
    private final RepositoryAddress mountpoint;
    private final AggregatorProvider aggregatorProvider;
    private final List<ArtifactHandler> artifactHandlers;
    private final WorkspaceFilter workspaceFilter;
    private final Set<String> nodeTypes = new HashSet<String>();
    private final VaultFsConfig config;
    private final AggregateImpl root;

    public static AggregateManager mount(VaultFsConfig config, WorkspaceFilter wspFilter, RepositoryAddress mountpoint, Session session) throws RepositoryException {
        assert (mountpoint.getWorkspace().equals(session.getWorkspace().getName()));
        if (config == null) {
            config = AggregateManagerImpl.getDefaultConfig();
        }
        if (wspFilter == null) {
            wspFilter = AggregateManagerImpl.getDefaultWorkspaceFilter();
        }
        Node rootNode = (Node)session.getItem(mountpoint.getPath());
        return new AggregateManagerImpl(config, wspFilter, mountpoint, rootNode, false);
    }

    public static AggregateManager mount(VaultFsConfig config, WorkspaceFilter wspFilter, Repository rep, Credentials credentials, RepositoryAddress mountpoint) throws RepositoryException {
        Item rootNode;
        if (config == null) {
            config = AggregateManagerImpl.getDefaultConfig();
        }
        if (wspFilter == null) {
            wspFilter = AggregateManagerImpl.getDefaultWorkspaceFilter();
        }
        String wspName = mountpoint.getWorkspace();
        try {
            rootNode = rep.login(credentials, wspName).getItem(mountpoint.getPath());
        }
        catch (LoginException e) {
            if (wspName == null) {
                rootNode = rep.login(credentials, "crx.default").getItem(mountpoint.getPath());
            }
            throw e;
        }
        if (!(rootNode instanceof Node)) {
            throw new IllegalArgumentException("Root path does not point to a node.");
        }
        return new AggregateManagerImpl(config, wspFilter, mountpoint, (Node)rootNode, true);
    }

    public static VaultFsConfig getDefaultConfig() {
        try {
            InputStream in = AggregateManagerImpl.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG);
            if (in == null) {
                throw new InternalError("Default config not in classpath: com/day/jcr/vault/fs/config/defaultConfig-1.1.xml");
            }
            return AbstractVaultFsConfig.load(in, DEFAULT_CONFIG);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
    }

    public static DefaultWorkspaceFilter getDefaultWorkspaceFilter() {
        try {
            InputStream in = AggregateManagerImpl.class.getClassLoader().getResourceAsStream(DEFAULT_WSP_FILTER);
            if (in == null) {
                throw new InternalError("Default filter not in classpath: com/day/jcr/vault/fs/config/defaultFilter-1.0.xml");
            }
            DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
            filter.load(in);
            return filter;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Internal error while parsing config.", e);
        }
    }

    public void unmount() throws RepositoryException {
        this.assertMounted();
        if (this.ownSession) {
            this.session.logout();
        }
        this.session = null;
    }

    public AggregateImpl getRoot() throws RepositoryException {
        this.assertMounted();
        return this.root;
    }

    public RepositoryAddress getMountpoint() {
        return this.mountpoint;
    }

    private AggregateManagerImpl(VaultFsConfig config, WorkspaceFilter wspFilter, RepositoryAddress mountpoint, Node rootNode, boolean ownSession) throws RepositoryException {
        this.session = rootNode.getSession();
        this.mountpoint = mountpoint;
        this.ownSession = ownSession;
        this.config = config;
        this.workspaceFilter = wspFilter;
        this.aggregatorProvider = new AggregatorProvider(config.getAggregators());
        this.artifactHandlers = Collections.unmodifiableList(config.getHandlers());
        RootAggregator rootAggregator = rootNode.getDepth() == 0 ? new RootAggregator() : this.getAggregator(rootNode);
        this.root = new AggregateImpl(this, rootNode.getPath(), (Aggregator)rootAggregator);
        this.initNodeTypes();
    }

    public Set<String> getNodeTypes() {
        return this.nodeTypes;
    }

    public void addNodeTypes(Node node) throws RepositoryException {
        this.internalAddNodeType(node.getPrimaryNodeType());
        for (NodeType nt : node.getMixinNodeTypes()) {
            this.internalAddNodeType(nt);
        }
    }

    private void internalAddNodeType(NodeType nodeType) {
        if (nodeType != null && !this.nodeTypes.contains(nodeType.getName())) {
            NodeType[] superTypes;
            this.nodeTypes.add(nodeType.getName());
            for (NodeType superType : superTypes = nodeType.getSupertypes()) {
                this.nodeTypes.add(superType.getName());
            }
            NodeDefinition[] nodeDefs = nodeType.getChildNodeDefinitions();
            if (nodeDefs != null) {
                for (NodeDefinition nodeDef : nodeDefs) {
                    this.internalAddNodeType(nodeDef.getDefaultPrimaryType());
                    NodeType[] reqs = nodeDef.getRequiredPrimaryTypes();
                    if (reqs == null) continue;
                    for (NodeType req : reqs) {
                        this.internalAddNodeType(req);
                    }
                }
            }
        }
    }

    private void initNodeTypes() throws RepositoryException {
        try {
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:HierarchyNode");
            this.session.getWorkspace().getNodeTypeManager().getNodeType("vlt:FullCoverage");
            return;
        }
        catch (RepositoryException e) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_NODETYPES);
            try {
                NodeTypeInstaller installer = NodeTypeHandling.getDefaultInstaller(this.session);
                CNDReader types = NodeTypeHandling.getCNDReader();
                types.read(new InputStreamReader(in, "utf8"), DEFAULT_NODETYPES, null);
                installer.install(null, types);
            }
            catch (Exception e2) {
                throw new RepositoryException("Error while importing nodetypes.", (Throwable)e2);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            return;
        }
    }

    public Aggregator getAggregator(Node node) throws RepositoryException {
        return this.aggregatorProvider.getAggregator(node);
    }

    public WorkspaceFilter getWorkspaceFilter() {
        return this.workspaceFilter;
    }

    public ImportInfo writeAggregate(AggregateImpl node, String reposName, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        this.assertMounted();
        if (reposName == null) {
            for (ArtifactHandler artifactHandler : this.artifactHandlers) {
                ImportInfo info = artifactHandler.accept(this.session, (Aggregate)node, (ArtifactSet)artifacts);
                if (info == null) continue;
                node.invalidate();
                return info;
            }
        } else {
            for (ArtifactHandler artifactHandler : this.artifactHandlers) {
                ImportInfo info = artifactHandler.accept(this.session, (Aggregate)node, reposName, (ArtifactSet)artifacts);
                if (info == null) continue;
                node.invalidate();
                return info;
            }
        }
        throw new IllegalStateException("No handler accepted artifacts " + artifacts);
    }

    private void assertMounted() throws RepositoryException {
        if (!this.isMounted()) {
            throw new RepositoryException("JcrFS is not mounted anymore.");
        }
    }

    public boolean isMounted() {
        return this.session != null && this.session.isLive();
    }

    public String getUserId() throws RepositoryException {
        this.assertMounted();
        return this.session.getUserID();
    }

    public String getWorkspace() throws RepositoryException {
        this.assertMounted();
        return this.session.getWorkspace().getName();
    }

    public Session getSession() {
        return this.session;
    }

    public void dumpConfig(PrintWriter out) throws IOException {
        DumpContext ctx = new DumpContext(out);
        ctx.println(false, "workspace filter");
        ctx.indent(false);
        this.workspaceFilter.dump(ctx, true);
        ctx.outdent();
        this.aggregatorProvider.dump(ctx, false);
        ctx.println(true, "handlers");
        ctx.indent(true);
        Iterator<ArtifactHandler> iter = this.artifactHandlers.iterator();
        while (iter.hasNext()) {
            ArtifactHandler h = iter.next();
            h.dump(ctx, !iter.hasNext());
        }
        ctx.outdent();
        ctx.flush();
    }

    public VaultFsConfig getConfig() {
        return this.config;
    }
}

