/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.aggregator;

import com.day.jcr.vault.fs.DirectoryArtifact;
import com.day.jcr.vault.fs.api.Aggregate;
import com.day.jcr.vault.fs.api.Aggregator;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactSet;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.Dumpable;
import com.day.jcr.vault.fs.api.Filter;
import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.ItemFilterSet;
import com.day.jcr.vault.fs.filter.NodeTypeItemFilter;
import com.day.jcr.vault.fs.impl.AggregateManagerImpl;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.DocViewSerializer;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.util.MimeTypes;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;

public class FileAggregator
implements Aggregator,
Dumpable {
    private final ItemFilterSet contentFilter = new ItemFilterSet();
    private final ItemFilterSet matchFilter = new ItemFilterSet();
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FileAggregator() {
        this.matchFilter.addInclude((Filter)new NodeTypeItemFilter("nt:file", true));
        this.matchFilter.addInclude((Filter)new NodeTypeItemFilter("nt:resource", true));
        this.matchFilter.seal();
    }

    public boolean matches(Node node) throws RepositoryException {
        return this.matchFilter.contains((Item)node, 0);
    }

    public boolean includes(Node root, Node node, Property prop) throws RepositoryException {
        if (node.getName().equals("jcr:content")) {
            String name = prop.getName();
            if (name.equals("jcr:data")) {
                return false;
            }
            if (name.equals("jcr:lastModified")) {
                return false;
            }
            if (name.equals("jcr:mimeType")) {
                String expected = MimeTypes.getMimeType((String)root.getName(), (String)"application/octet-stream");
                return !expected.equals(prop.getString());
            }
        } else if (node == root && node.isNodeType("nt:resource")) {
            String name = prop.getName();
            if (name.equals("jcr:data")) {
                return false;
            }
            if (name.equals("jcr:lastModified")) {
                return false;
            }
        }
        return true;
    }

    public ItemFilterSet getContentFilter() {
        return this.contentFilter;
    }

    public boolean includes(Node root, Node node) throws RepositoryException {
        int depth = node.getDepth() - root.getDepth();
        boolean isFile = root.isNodeType("nt:file");
        if (depth == 0) {
            return true;
        }
        if (depth == 1 && isFile && node.getName().equals("jcr:content")) {
            return true;
        }
        return !this.contentFilter.isEmpty() && this.contentFilter.contains((Item)node, depth);
    }

    public boolean hasFullCoverage() {
        return false;
    }

    public boolean isDefault() {
        return false;
    }

    public ArtifactSet createArtifacts(Aggregate aggregate) throws RepositoryException {
        boolean needsDir;
        String mimeType;
        ArtifactSetImpl artifacts = new ArtifactSetImpl();
        Node node = aggregate.getNode();
        ((AggregateManagerImpl)aggregate.getManager()).addNodeTypes(node);
        Node content = node;
        if (content.isNodeType("nt:file")) {
            content = node.getNode("jcr:content");
            ((AggregateManagerImpl)aggregate.getManager()).addNodeTypes(content);
        }
        long lastModified = 0L;
        String encoding = null;
        try {
            lastModified = content.getProperty("jcr:lastModified").getDate().getTimeInMillis();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            mimeType = content.getProperty("jcr:mimeType").getString();
        }
        catch (RepositoryException e) {
            mimeType = "application/octet-stream";
        }
        if (content.hasProperty("jcr:encoding")) {
            try {
                encoding = content.getProperty("jcr:encoding").getString();
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        boolean bl = needsDir = !node.getPrimaryNodeType().getName().equals("nt:file");
        if (!needsDir) {
            for (NodeType mix : node.getMixinNodeTypes()) {
                if (mix.getName().equals("mix:lockable")) continue;
                needsDir = true;
                break;
            }
        }
        if (!needsDir) {
            boolean bl2 = needsDir = !content.getPrimaryNodeType().getName().equals("nt:resource");
        }
        if (!needsDir) {
            boolean bl3 = needsDir = content.getMixinNodeTypes().length > 0;
        }
        if (!needsDir) {
            boolean bl4 = needsDir = encoding != null;
        }
        if (!needsDir) {
            needsDir = !MimeTypes.matches((String)node.getName(), (String)mimeType, (String)"application/octet-stream");
        }
        String name = aggregate.getName();
        artifacts.add(null, name, "", ArtifactType.FILE, content.getProperty("jcr:data"), lastModified);
        if (needsDir) {
            DirectoryArtifact parent = new DirectoryArtifact(name, ".dir");
            artifacts.add(parent);
            DocViewSerializer ser = new DocViewSerializer(aggregate);
            artifacts.add((Artifact)parent, "", ".content.xml", ArtifactType.PRIMARY, ser, 0L);
        }
        return artifacts;
    }

    public ImportInfo remove(Node node, boolean recursive, boolean trySave) throws RepositoryException {
        ImportInfoImpl info = new ImportInfoImpl();
        info.onDeleted(node.getPath());
        Node parent = node.getParent();
        node.remove();
        if (trySave) {
            parent.save();
        }
        return info;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
    }
}

