/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.aggregator;

import com.day.jcr.vault.fs.DirectoryArtifact;
import com.day.jcr.vault.fs.api.Aggregate;
import com.day.jcr.vault.fs.api.Aggregator;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactSet;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.Dumpable;
import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.ItemFilterSet;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.DocViewSerializer;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;

public class GenericAggregator
implements Aggregator,
Dumpable {
    private String name;
    private boolean fullCoverage = false;
    private final ItemFilterSet contentFilter = new ItemFilterSet();
    private final ItemFilterSet matchFilter = new ItemFilterSet();
    private boolean isDefault = false;

    public boolean hasFullCoverage() {
        return this.fullCoverage;
    }

    public void setHasFullCoverage(String hasFullCoverage) {
        this.fullCoverage = Boolean.valueOf(hasFullCoverage);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setIsDefault(String aDefault) {
        this.isDefault = Boolean.valueOf(aDefault);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullCoverage(String fullCoverage) {
        this.fullCoverage = Boolean.valueOf(fullCoverage);
    }

    public ItemFilterSet getContentFilter() {
        return this.contentFilter;
    }

    public ItemFilterSet getMatchFilter() {
        return this.matchFilter;
    }

    public boolean matches(Node node) throws RepositoryException {
        return this.matchFilter.contains((Item)node, 0);
    }

    public boolean includes(Node root, Node node) throws RepositoryException {
        return this.contentFilter.contains((Item)node, node.getDepth() - root.getDepth());
    }

    public boolean includes(Node root, Node parent, Property property) throws RepositoryException {
        return this.contentFilter.contains((Item)property, property.getDepth() - root.getDepth());
    }

    public ArtifactSet createArtifacts(Aggregate aggregate) throws RepositoryException {
        ArtifactSetImpl artifacts = new ArtifactSetImpl();
        artifacts.setCoverage(this.getContentFilter());
        ArtifactType type = ArtifactType.PRIMARY;
        String name = aggregate.getName();
        String ext = ".xml";
        DirectoryArtifact parent = null;
        if (!this.hasFullCoverage()) {
            parent = new DirectoryArtifact(name);
            artifacts.add(parent);
            name = "";
            ext = ".content.xml";
            if (aggregate.getNode().getPrimaryNodeType().getName().equals("nt:folder") && aggregate.getNode().getMixinNodeTypes().length == 0) {
                return artifacts;
            }
        }
        DocViewSerializer ser = new DocViewSerializer(aggregate);
        artifacts.add((Artifact)parent, name, ext, type, ser, 0L);
        if (!aggregate.getBinaries().isEmpty()) {
            int pathLen;
            if (this.hasFullCoverage()) {
                assert (parent == null);
                parent = new DirectoryArtifact(aggregate.getName());
                artifacts.add(parent);
            }
            if ((pathLen = aggregate.getPath().length()) > 1) {
                ++pathLen;
            }
            for (Property prop : aggregate.getBinaries()) {
                String relPath = prop.getPath().substring(pathLen);
                artifacts.add((Artifact)parent, relPath, ".binary", ArtifactType.BINARY, prop, 0L);
            }
        }
        return artifacts;
    }

    public ImportInfo remove(Node node, boolean recursive, boolean trySave) throws RepositoryException {
        if (this.fullCoverage && !recursive) {
            throw new RepositoryException("Unable to remove content since aggregation has children and recursive is not set.");
        }
        ImportInfoImpl info = new ImportInfoImpl();
        info.onDeleted(node.getPath());
        Node parent = node.getParent();
        node.remove();
        if (trySave) {
            parent.save();
        }
        return info;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
        ctx.indent(isLast);
        ctx.printf(false, "name: %s", new Object[]{this.getName()});
        ctx.printf(false, "fullCoverage: %b", new Object[]{this.hasFullCoverage()});
        ctx.printf(false, "default: %b", new Object[]{this.isDefault()});
        ctx.println(false, "Content Filter");
        ctx.indent(false);
        this.getContentFilter().dump(ctx, true);
        ctx.outdent();
        ctx.println(true, "Match Filter");
        ctx.indent(true);
        this.getMatchFilter().dump(ctx, true);
        ctx.outdent();
        ctx.outdent();
    }
}

