/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.aggregator;

import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.DumpContext;
import com.day.jcr.vault.fs.api.Filter;
import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.filter.NodeTypeItemFilter;
import com.day.jcr.vault.fs.impl.AggregateImpl;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.aggregator.GenericAggregator;
import com.day.jcr.vault.fs.impl.io.CNDSerializer;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

public class NodeTypeAggregator
extends GenericAggregator {
    public boolean hasFullCoverage() {
        return true;
    }

    public boolean matches(Node node) throws RepositoryException {
        if (this.getMatchFilter().isEmpty()) {
            this.getMatchFilter().addInclude((Filter)new NodeTypeItemFilter("nt:nodeType", true));
        }
        return super.matches(node);
    }

    public ArtifactSetImpl createArtifacts(AggregateImpl aggregate) throws RepositoryException {
        ArtifactSetImpl artifacts = new ArtifactSetImpl();
        CNDSerializer ser = new CNDSerializer(aggregate);
        artifacts.add(null, aggregate.getRelPath(), ".xcnd", ArtifactType.PRIMARY, ser, 0L);
        return artifacts;
    }

    public ImportInfo remove(Node node, boolean recursive, boolean trySave) throws RepositoryException {
        ImportInfoImpl info = new ImportInfoImpl();
        info.onDeleted(node.getPath());
        Node parent = node.getParent();
        node.remove();
        if (trySave) {
            parent.save();
        }
        return info;
    }

    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, this.getClass().getSimpleName());
    }
}

