/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.Aggregate;
import com.day.jcr.vault.fs.impl.io.AggregateWalkListener;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.SessionNamespaceResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSAXFormatter
implements AggregateWalkListener {
    public static final String NODE_ELEMENT = "node";
    public static final String PREFIXED_NODE_ELEMENT = "sv:node";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String PREFIXED_PROPERTY_ELEMENT = "sv:property";
    public static final String VALUE_ELEMENT = "value";
    public static final String PREFIXED_VALUE_ELEMENT = "sv:value";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PREFIXED_NAME_ATTRIBUTE = "sv:name";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PREFIXED_TYPE_ATTRIBUTE = "sv:type";
    public static final String CDATA_TYPE = "CDATA";
    public static final String ENUMERATION_TYPE = "ENUMERATION";
    protected boolean skipBinary = true;
    protected final Session session;
    protected final NamespaceResolver nsResolver;
    protected final ContentHandler contentHandler;
    protected final String jcrPrimaryType;
    protected final String ntUnstructured;
    protected final String jcrMixinTypes;
    protected final String jcrUUID;
    protected final String jcrRoot;
    protected final String jcrXMLText;
    protected final String jcrXMLCharacters;
    protected final Aggregate aggregate;

    protected AbstractSAXFormatter(Aggregate aggregate, ContentHandler contentHandler) throws RepositoryException {
        this.aggregate = aggregate;
        this.session = aggregate.getNode().getSession();
        this.nsResolver = new SessionNamespaceResolver(this.session);
        this.contentHandler = contentHandler;
        DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.nsResolver);
        try {
            this.jcrPrimaryType = npResolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
            this.jcrMixinTypes = npResolver.getJCRName(NameConstants.JCR_MIXINTYPES);
            this.jcrUUID = npResolver.getJCRName(NameConstants.JCR_UUID);
            this.jcrRoot = npResolver.getJCRName(NameConstants.JCR_ROOT);
            this.jcrXMLText = npResolver.getJCRName(NameConstants.JCR_XMLTEXT);
            this.jcrXMLCharacters = npResolver.getJCRName(NameConstants.JCR_XMLCHARACTERS);
            this.ntUnstructured = npResolver.getJCRName(NameConstants.NT_UNSTRUCTURED);
        }
        catch (NamespaceException e) {
            String msg = "internal error: failed to resolve namespace mappings";
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public void onWalkBegin(Node root) throws RepositoryException {
        try {
            this.contentHandler.startDocument();
            this.startNamespaceDeclarations();
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void onWalkEnd(Node root) throws RepositoryException {
        try {
            this.endNamespaceDeclarations();
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void startNamespaceDeclarations() throws RepositoryException, SAXException {
        String[] uris;
        for (String uri : uris = this.aggregate.getNamespaceURIs()) {
            String prefix = this.aggregate.getNamespacePrefix(uri);
            if ("xml".equals(prefix)) continue;
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    protected void endNamespaceDeclarations() throws RepositoryException, SAXException {
        String[] uris;
        for (String uri : uris = this.aggregate.getNamespaceURIs()) {
            String prefix = this.aggregate.getNamespacePrefix(uri);
            if ("xml".equals(prefix)) continue;
            this.contentHandler.endPrefixMapping(prefix);
        }
    }
}

