/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.Aggregate;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.io.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class CNDSerializer
implements Serializer {
    private static final String INDENT = "  ";
    private final Aggregate aggregate;

    public CNDSerializer(Aggregate aggregate) {
        this.aggregate = aggregate;
    }

    public void writeContent(OutputStream out) throws IOException, RepositoryException {
        String[] uris;
        OutputStreamWriter w = new OutputStreamWriter(out, "utf-8");
        for (String uri : uris = this.aggregate.getNamespaceURIs()) {
            String prefix = this.aggregate.getNamespacePrefix(uri);
            w.write("<'");
            w.write(prefix);
            w.write("'='");
            w.write(this.escape(uri));
            w.write("'>\n");
        }
        w.write("\n");
        this.writeNodeTypeDef(w, this.aggregate.getNode());
        ((Writer)w).close();
        out.flush();
    }

    private void writeNodeTypeDef(Writer out, Node node) throws IOException, RepositoryException {
        this.writeName(out, node);
        this.writeSupertypes(out, node);
        this.writeOptions(out, node);
        this.writeDefs(out, node);
        out.write("\n");
    }

    private void writeName(Writer out, Node node) throws IOException, RepositoryException {
        out.write("[");
        out.write(node.getProperty("jcr:nodeTypeName").getString());
        out.write("]");
    }

    private void writeSupertypes(Writer out, Node node) throws IOException, RepositoryException {
        Value[] types = node.getProperty("jcr:supertypes").getValues();
        String delim = " > ";
        for (Value s : types) {
            out.write(delim);
            out.write(s.getString());
            delim = ", ";
        }
    }

    private void writeOptions(Writer out, Node node) throws IOException, RepositoryException {
        String delim = "\n   ";
        if (node.getProperty("jcr:hasOrderableChildNodes").getBoolean()) {
            out.write(delim);
            out.write("orderable");
            delim = " ";
        }
        if (node.getProperty("jcr:isMixin").getBoolean()) {
            out.write(delim);
            out.write("mixin");
        }
    }

    private void writeDefs(Writer out, Node node) throws IOException, RepositoryException {
        Node child;
        NodeIterator iter = node.getNodes();
        String primary = null;
        if (node.hasProperty("jcr:primaryItemName")) {
            primary = node.getProperty("jcr:primaryItemName").getString();
        }
        while (iter.hasNext()) {
            child = iter.nextNode();
            if (!child.getPrimaryNodeType().getName().equals("nt:propertyDefinition")) continue;
            this.writePropDef(out, child, primary);
        }
        iter = node.getNodes();
        while (iter.hasNext()) {
            child = iter.nextNode();
            if (!child.getPrimaryNodeType().getName().equals("nt:childNodeDefinition")) continue;
            this.writeNodeDef(out, child, primary);
        }
    }

    private void writePropDef(Writer out, Node node, String primary) throws IOException, RepositoryException {
        String opv;
        out.write("\n  - ");
        String name = "*";
        if (node.hasProperty("jcr:name")) {
            name = node.getProperty("jcr:name").getString();
        }
        out.write(name);
        out.write(" (");
        out.write(node.getProperty("jcr:requiredType").getString().toLowerCase());
        out.write(")");
        if (node.hasProperty("jcr:defaultValues")) {
            this.writeDefaultValues(out, node.getProperty("jcr:defaultValues").getValues());
        }
        if (primary != null && primary.equals(name)) {
            out.write(" primary");
        }
        if (node.getProperty("jcr:mandatory").getBoolean()) {
            out.write(" mandatory");
        }
        if (node.getProperty("jcr:autoCreated").getBoolean()) {
            out.write(" autocreated");
        }
        if (node.getProperty("jcr:protected").getBoolean()) {
            out.write(" protected");
        }
        if (node.getProperty("jcr:multiple").getBoolean()) {
            out.write(" multiple");
        }
        if (!(opv = node.getProperty("jcr:onParentVersion").getString().toLowerCase()).equals("copy")) {
            out.write(" ");
            out.write(opv);
        }
        if (node.hasProperty("jcr:valueConstraints")) {
            this.writeValueConstraints(out, node.getProperty("jcr:valueConstraints").getValues());
        }
    }

    private void writeDefaultValues(Writer out, Value[] dva) throws IOException, RepositoryException {
        if (dva != null && dva.length > 0) {
            String delim = " = '";
            for (Value value : dva) {
                out.write(delim);
                out.write(this.escape(value.getString()));
                out.write("'");
                delim = ", '";
            }
        }
    }

    private void writeValueConstraints(Writer out, Value[] vca) throws IOException, RepositoryException {
        String delim = "\n    < ";
        for (Value v : vca) {
            out.write(delim);
            out.write("'");
            out.write(this.escape(v.getString()));
            out.write("'");
            delim = ", ";
        }
    }

    private void writeNodeDef(Writer out, Node node, String primary) throws IOException, RepositoryException {
        String opv;
        out.write("\n  + ");
        String name = "*";
        if (node.hasProperty("jcr:name")) {
            name = node.getProperty("jcr:name").getString();
        }
        out.write(name);
        this.writeRequiredTypes(out, node.getProperty("jcr:requiredPrimaryTypes").getValues());
        if (node.hasProperty("jcr:defaultPrimaryType")) {
            this.writeDefaultType(out, node.getProperty("jcr:defaultPrimaryType").getString());
        }
        if (primary != null && primary.equals(name)) {
            out.write(" primary");
        }
        if (node.getProperty("jcr:mandatory").getBoolean()) {
            out.write(" mandatory");
        }
        if (node.getProperty("jcr:autoCreated").getBoolean()) {
            out.write(" autocreated");
        }
        if (node.getProperty("jcr:protected").getBoolean()) {
            out.write(" protected");
        }
        if (node.getProperty("jcr:sameNameSiblings").getBoolean()) {
            out.write(" multiple");
        }
        if (!(opv = node.getProperty("jcr:onParentVersion").getString().toLowerCase()).equals("copy")) {
            out.write(" ");
            out.write(opv);
        }
    }

    private void writeRequiredTypes(Writer out, Value[] reqTypes) throws IOException, RepositoryException {
        if (reqTypes.length > 0) {
            String delim = " (";
            for (Value value : reqTypes) {
                out.write(delim);
                out.write(value.getString());
                delim = ", ";
            }
            out.write(")");
        }
    }

    private void writeDefaultType(Writer out, String defType) throws IOException {
        if (!defType.equals("*")) {
            out.write(" = ");
            out.write(defType);
        }
    }

    private String escape(String s) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\\') {
                sb.insert(i, '\\');
                ++i;
                continue;
            }
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++i;
        }
        return sb.toString();
    }

    public SerializationType getType() {
        return SerializationType.CND;
    }
}

