/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.impl.io.NameSpace;
import com.day.jcr.vault.fs.io.DocViewAnalyzerListener;
import java.io.IOException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocViewAnalyzer
extends DefaultHandler
implements NamespaceResolver {
    static final Logger log = LoggerFactory.getLogger(DocViewAnalyzer.class);
    private final Session session;
    private final String rootPath;
    private NameSpace nsStack = null;
    private StackElement stack;
    private final DefaultNamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)this);
    private final DocViewAnalyzerListener listener;

    public static void analyze(DocViewAnalyzerListener listener, Session session, String rootPath, InputSource source) throws IOException {
        try {
            DocViewAnalyzer handler = new DocViewAnalyzer(listener, session, rootPath);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    private DocViewAnalyzer(DocViewAnalyzerListener listener, Session session, String rootPath) {
        this.listener = listener;
        this.session = session;
        this.rootPath = rootPath;
    }

    public void startDocument() throws SAXException {
        this.stack = new StackElement(null, Text.getRelativeParent((String)this.rootPath, (int)1));
    }

    public void endDocument() throws SAXException {
        if (this.stack.parent != null) {
            throw new IllegalStateException("stack mismatch");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String label;
        String name;
        int idx;
        if (this.stack.parent == null && localName.equals(NameConstants.JCR_ROOT.getLocalName()) && uri.equals(NameConstants.JCR_ROOT.getNamespaceURI())) {
            qName = Text.getName((String)this.rootPath);
        }
        if ((idx = (name = (label = ISO9075.decode((String)qName))).lastIndexOf(91)) > 0) {
            name = name.substring(0, idx);
        }
        this.stack = this.stack.push(name);
        if (attributes.getLength() == 0) {
            this.listener.onNode(this.stack.getPath(), "");
        } else {
            String pt = attributes.getValue(NameConstants.JCR_PRIMARYTYPE.getNamespaceURI(), NameConstants.JCR_PRIMARYTYPE.getLocalName());
            this.listener.onNode(this.stack.getPath(), pt == null ? "" : pt);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.stack = this.stack.pop();
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.session.getNamespaceURI(prefix);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.session.getNamespacePrefix(uri);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    private static class StackElement {
        private final String path;
        final StackElement parent;

        public StackElement(StackElement parent, String name) {
            if (parent == null) {
                this.parent = null;
                this.path = name;
            } else {
                this.path = parent.path + "/" + name;
                this.parent = parent;
            }
        }

        public String getPath() {
            return this.path;
        }

        public StackElement push(String name) {
            return new StackElement(this, name);
        }

        public StackElement pop() {
            return this.parent;
        }
    }
}

