/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.PropertyValueArtifact;
import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.ItemFilterSet;
import com.day.jcr.vault.fs.api.NodeNameList;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.fs.impl.io.NameSpace;
import com.day.jcr.vault.util.DocViewProperty;
import com.day.jcr.vault.util.MimeTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocViewSAXImporter
extends DefaultHandler
implements NamespaceResolver {
    static final Logger log = LoggerFactory.getLogger(DocViewSAXImporter.class);
    static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    static final Set<String> PROTECTED_PROPERTIES;
    private NameSpace nsStack = null;
    private final Session session;
    private final Node parentNode;
    private final String rootNodeName;
    private final int rootDepth;
    private StackElement stack;
    private boolean skipped = false;
    private final ItemFilterSet filter;
    private final WorkspaceFilter wspFilter;
    private Map<String, Map<String, BlobInfo>> binaries = new HashMap<String, Map<String, BlobInfo>>();
    private Set<String> hints = new HashSet<String>();
    private Set<String> saveProperties = new HashSet<String>();
    private final DefaultNamePathResolver npResolver = new DefaultNamePathResolver((NamespaceResolver)this);
    private ImportInfoImpl importInfo = new ImportInfoImpl();

    public DocViewSAXImporter(Node parentNode, String rootNodeName, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter) throws RepositoryException {
        this.filter = artifacts.getCoverage();
        this.wspFilter = wspFilter;
        this.parentNode = parentNode;
        this.rootDepth = parentNode.getDepth() + 1;
        this.session = parentNode.getSession();
        this.rootNodeName = rootNodeName;
        String rootPath = parentNode.getPath();
        if (!rootPath.equals("/")) {
            rootPath = rootPath + "/";
        }
        for (Artifact a : artifacts.values(ArtifactType.BINARY)) {
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.FILE)) {
            this.registerBinary(a, rootPath);
        }
        for (Artifact a : artifacts.values(ArtifactType.HINT)) {
            this.hints.add(rootPath + a.getRelativePath());
        }
    }

    private void registerBinary(Artifact a, String rootPath) throws RepositoryException {
        String path = rootPath + a.getRelativePath();
        int idx = -1;
        int pos = path.lastIndexOf(91);
        if (pos > 0) {
            idx = Integer.parseInt(path.substring(pos + 1, path.length() - 1));
            path = path.substring(0, pos);
        }
        if (a.getType() == ArtifactType.FILE && a instanceof PropertyValueArtifact) {
            String parentPath = ((PropertyValueArtifact)a).getProperty().getParent().getPath();
            this.saveProperties.add(parentPath + "/" + "jcr:data");
            this.saveProperties.add(parentPath + "/" + "jcr:lastModified");
        } else {
            BlobInfo info;
            this.saveProperties.add(path);
            String parentPath = Text.getRelativeParent((String)path, (int)1);
            String name = Text.getName((String)path);
            Map<String, BlobInfo> infoSet = this.binaries.get(parentPath);
            if (infoSet == null) {
                infoSet = new HashMap<String, BlobInfo>();
                this.binaries.put(parentPath, infoSet);
            }
            if ((info = infoSet.get(name)) == null) {
                info = new BlobInfo(idx >= 0);
                infoSet.put(name, info);
            }
            if (idx >= 0) {
                info.add(idx, a);
            } else {
                info.add(a);
            }
        }
        log.debug("scheduling binary: {}{}", (Object)rootPath, (Object)(a.getRelativePath() + a.getExtension()));
    }

    private boolean isIncluded(Item item, int depth) throws RepositoryException {
        return this.wspFilter.contains(item.getPath()) && (depth == 0 || this.filter.contains(item, depth));
    }

    public ImportInfoImpl getInfo() {
        return this.importInfo;
    }

    @Override
    public void startDocument() throws SAXException {
        this.stack = new StackElement(null, this.parentNode);
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.stack.isRoot()) {
            throw new IllegalStateException("stack mismatch");
        }
        for (String parentPath : this.binaries.keySet()) {
            Map<String, BlobInfo> blobs = this.binaries.get(parentPath);
            log.debug("processing binaries at {}", (Object)parentPath);
            try {
                Node fNode;
                BlobInfo info;
                Node node;
                if (this.session.itemExists(parentPath)) {
                    node = (Node)this.session.getItem(parentPath);
                    for (String propName : blobs.keySet()) {
                        info = blobs.get(propName);
                        if (node.hasNode(propName)) {
                            this.handleBinNode(node.getNode(propName), info);
                            continue;
                        }
                        if (info.isFile()) {
                            fNode = node.addNode(propName, "nt:file");
                            this.importInfo.onCreated(fNode.getPath());
                            this.handleBinNode(fNode, info);
                            continue;
                        }
                        if (info.isMulti) {
                            node.setProperty(propName, info.getValues(this.session));
                        } else {
                            node.setProperty(propName, info.getValue(this.session));
                        }
                        this.importInfo.onModified(node.getPath());
                    }
                    continue;
                }
                log.warn("binaries parent path does not exist: {}", (Object)parentPath);
                node = null;
                for (String propName : blobs.keySet()) {
                    info = blobs.get(propName);
                    if (!info.isFile()) continue;
                    if (node == null) {
                        node = this.createNodeDeep(parentPath);
                    }
                    fNode = node.addNode(propName, "nt:file");
                    this.importInfo.onCreated(fNode.getPath());
                    this.handleBinNode(fNode, info);
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private Node createNodeDeep(String path) throws RepositoryException {
        Node node;
        if (this.session.itemExists(path)) {
            return (Node)this.session.getItem(path);
        }
        int idx = path.lastIndexOf(47);
        if (idx <= 0) {
            return this.session.getRootNode();
        }
        String parentPath = path.substring(0, idx);
        String name = path.substring(idx + 1);
        Node parentNode = this.createNodeDeep(parentPath);
        if (parentNode.isNodeType("nt:folder")) {
            try {
                node = parentNode.addNode(name);
            }
            catch (RepositoryException e) {
                node = parentNode.addNode(name, "nt:folder");
            }
        } else {
            node = this.createNodeDeep(parentPath).addNode(name);
        }
        this.importInfo.onCreated(node.getPath());
        return node;
    }

    private void handleBinNode(Node node, BlobInfo info) throws RepositoryException, IOException {
        log.debug("handling binary file at {}", (Object)node.getPath());
        if (info.isMulti) {
            throw new IllegalStateException("unable to add MV binary to node " + node.getPath());
        }
        if (node.isNodeType("nt:file")) {
            node = node.hasNode("jcr:content") ? node.getNode("jcr:content") : node.addNode("jcr:content", "nt:resource");
        }
        Artifact a = (Artifact)info.artifacts.get(0);
        Property prop = node.setProperty("jcr:data", a.getInputStream());
        this.importInfo.onModified(prop.getPath());
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(a.getLastModified());
        node.setProperty("jcr:lastModified", lastModified);
        if (!node.hasProperty("jcr:mimeType")) {
            String mimeType = a.getContentType();
            if (mimeType == null) {
                mimeType = Text.getName((String)a.getRelativePath(), (char)'.');
                mimeType = MimeTypes.getMimeType((String)mimeType, (String)"application/octet-stream");
            }
            node.setProperty("jcr:mimeType", mimeType);
        }
        if (node.isNew()) {
            this.importInfo.onCreated(node.getPath());
        } else {
            this.importInfo.onModified(node.getPath());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        String oldPrefix;
        log.debug("-> prefixMapping for {}:{}", (Object)prefix, (Object)uri);
        NameSpace ns = new NameSpace(prefix, uri);
        ns.next = this.nsStack;
        this.nsStack = ns;
        try {
            oldPrefix = this.session.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            try {
                this.session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
            }
            catch (RepositoryException e1) {
                throw new SAXException((Exception)((Object)e));
            }
            oldPrefix = prefix;
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (!oldPrefix.equals(prefix)) {
            try {
                this.session.setNamespacePrefix(prefix, uri);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        log.debug("<- prefixMapping for {}", (Object)prefix);
        NameSpace ns = this.nsStack;
        NameSpace prev = null;
        while (ns != null && !ns.prefix.equals(prefix)) {
            prev = ns;
            ns = ns.next;
        }
        if (ns == null) {
            throw new SAXException("Illegal state: prefix " + prefix + " never mapped.");
        }
        if (prev == null) {
            this.nsStack = ns.next;
        } else {
            prev.next = ns.next;
        }
        ns = ns.next;
        while (ns != null && !ns.prefix.equals(prefix)) {
            ns = ns.next;
        }
        if (ns != null) {
            try {
                this.session.setNamespacePrefix(prefix, ns.uri);
            }
            catch (RepositoryException e) {
                throw new SAXException((Exception)((Object)e));
            }
            log.debug("   remapped: {}:{}", (Object)prefix, (Object)ns.uri);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String label;
        if (this.stack.isRoot() && localName.equals(NameConstants.JCR_ROOT.getLocalName()) && uri.equals(NameConstants.JCR_ROOT.getNamespaceURI())) {
            qName = this.rootNodeName;
        }
        String name = label = ISO9075.decode((String)qName);
        log.debug("-> element {}", (Object)label);
        int idx = name.lastIndexOf(91);
        if (idx > 0) {
            name = name.substring(0, idx);
        }
        try {
            this.stack.addName(label);
            Node node = this.stack.getNode();
            if (node == null) {
                this.stack = this.stack.push(null);
            } else if (attributes.getLength() == 0) {
                log.debug("Skipping empty node {}", (Object)(node.getPath() + "/" + name));
                this.skipped = true;
            } else {
                try {
                    this.stack = this.stack.push(this.addNode(name, label, attributes));
                }
                catch (RepositoryException e) {
                    String errPath = node.getPath() + "/" + name;
                    log.error("Error during processing of {}: {}", (Object)errPath, (Object)e.toString());
                    this.importInfo.onError(errPath, (Exception)((Object)e));
                    this.stack = this.stack.push(null);
                }
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private Node addNode(String name, String label, Attributes attributes) throws RepositoryException, IOException {
        String newPath;
        Node currentNode = this.stack.getNode();
        HashMap<String, DocViewProperty> props = new HashMap<String, DocViewProperty>();
        String uuid = null;
        String[] mixins = null;
        String primary = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!attributes.getType(i).equals("CDATA")) continue;
            Name pName = NameFactoryImpl.getInstance().create(attributes.getURI(i), ISO9075.decode((String)attributes.getLocalName(i)));
            DocViewProperty info = DocViewProperty.parse((String)this.npResolver.getJCRName(pName), (String)attributes.getValue(i));
            props.put(info.name, info);
            if (pName.equals(NameConstants.JCR_UUID)) {
                uuid = info.values[0];
                continue;
            }
            if (pName.equals(NameConstants.JCR_PRIMARYTYPE)) {
                primary = info.values[0];
                continue;
            }
            if (!pName.equals(NameConstants.JCR_MIXINTYPES)) continue;
            mixins = info.values;
        }
        Node oldNode = null;
        Node node = null;
        if (label.equals("")) {
            node = currentNode;
        } else if (uuid == null) {
            if (currentNode.hasNode(label)) {
                node = currentNode.getNode(label);
                if (primary != null && !node.getPrimaryNodeType().getName().equals(primary)) {
                    oldNode = node;
                    node = null;
                }
            }
        } else {
            try {
                node = this.session.getNodeByUUID(uuid);
                if (!node.getParent().isSame((Item)currentNode)) {
                    throw new RepositoryException("Illegal state. Will not move referenceable nodes.");
                }
            }
            catch (ItemNotFoundException e) {
                // empty catch block
            }
            if (node == null) {
                if (currentNode.hasNode(label)) {
                    node = currentNode.getNode(label);
                    if (primary != null && !node.getPrimaryNodeType().getName().equals(primary)) {
                        oldNode = node;
                        node = null;
                    }
                }
            } else if (node.getName().equals(name)) {
                if (primary != null && !node.getPrimaryNodeType().getName().equals(primary)) {
                    oldNode = node;
                    node = null;
                }
            } else {
                oldNode = node;
                node = null;
            }
        }
        if (oldNode != null && !this.isIncluded((Item)oldNode, oldNode.getDepth() - this.rootDepth)) {
            node = oldNode;
            oldNode = null;
        }
        if (!(newPath = currentNode.getPath()).endsWith("/")) {
            newPath = newPath + "/";
        }
        newPath = newPath + name;
        Map<String, BlobInfo> blobs = this.binaries.get(newPath);
        if (oldNode != null) {
            Node child;
            NodeIterator iter;
            this.ensureCheckedOut(oldNode);
            Node tmpNode = null;
            try {
                iter = oldNode.getNodes();
                while (iter.hasNext()) {
                    child = iter.nextNode();
                    if (tmpNode == null) {
                        tmpNode = this.session.getRootNode().addNode("tmp" + System.currentTimeMillis(), "nt:unstructured");
                    }
                    this.session.move(child.getPath(), tmpNode.getPath() + "/" + child.getName());
                }
            }
            catch (RepositoryException e) {
                log.warn("error while moving child nodes (ignored)", (Throwable)e);
            }
            if (blobs != null) {
                for (BlobInfo info : blobs.values()) {
                    info.detach();
                }
            }
            oldNode.remove();
            node = this.createNode(currentNode, name, props.values());
            if (tmpNode != null) {
                iter = tmpNode.getNodes();
                while (iter.hasNext()) {
                    child = iter.nextNode();
                    this.session.move(child.getPath(), node.getPath() + "/" + child.getName());
                }
                tmpNode.remove();
            }
            this.importInfo.onReplaced(node.getPath());
            return node;
        }
        DocViewProperty coProp = (DocViewProperty)props.get("jcr:isCheckedOut");
        if (coProp != null && uuid != null && !coProp.values[0].equals("true")) {
            this.importInfo.registerToVersion(uuid);
        }
        if (node == null) {
            if (!props.containsKey("jcr:mixinTypes")) {
                props.put("jcr:mixinTypes", new DocViewProperty("jcr:mixinTypes", new String[0], true, 7));
            }
            if ((node = this.createNode(currentNode, name, props.values())).isNodeType("nt:resource") && !node.hasProperty("jcr:data")) {
                this.importInfo.onMissing(node.getPath() + "/" + "jcr:data");
            }
            this.importInfo.onCreated(node.getPath());
        } else if (this.isIncluded((Item)node, node.getDepth() - this.rootDepth)) {
            NodeType[] mixs;
            boolean modified = false;
            props.remove("jcr:primaryType");
            props.remove("jcr:mixinTypes");
            props.remove("jcr:uuid");
            props.remove("jcr:isCheckedOut");
            props.remove("jcr:baseVersion");
            props.remove("jcr:predecessors");
            props.remove("jcr:successors");
            props.remove("jcr:versionHistory");
            HashSet<String> existingMixing = new HashSet<String>();
            for (NodeType nodeType : mixs = node.getMixinNodeTypes()) {
                existingMixing.add(nodeType.getName());
            }
            if (mixins != null) {
                for (String string : mixins) {
                    if (existingMixing.remove(string)) continue;
                    this.ensureCheckedOut(node);
                    node.addMixin(string);
                    modified = true;
                }
            }
            for (String mixing : existingMixing) {
                this.ensureCheckedOut(node);
                node.removeMixin(mixing);
                modified = true;
            }
            PropertyIterator propertyIterator = node.getProperties();
            while (propertyIterator.hasNext()) {
                Property p = propertyIterator.nextProperty();
                String propName = p.getName();
                if (PROTECTED_PROPERTIES.contains(propName) || props.containsKey(propName) || this.saveProperties.contains(p.getPath())) continue;
                try {
                    this.ensureCheckedOut(node);
                    p.remove();
                    modified = true;
                }
                catch (RepositoryException repositoryException) {}
            }
            for (DocViewProperty prop : props.values()) {
                if (prop == null || PROTECTED_PROPERTIES.contains(prop.name)) continue;
                try {
                    if (prop.modified(node)) {
                        this.ensureCheckedOut(node);
                    }
                    modified |= prop.apply(node);
                }
                catch (RepositoryException repositoryException) {
                    log.warn("Error while setting property (ignore): " + (Object)((Object)repositoryException));
                }
            }
            if (modified) {
                if (node.isNodeType("nt:resource") && !node.hasProperty("jcr:data")) {
                    this.importInfo.onMissing(node.getPath() + "/" + "jcr:data");
                }
                this.importInfo.onModified(node.getPath());
            } else {
                this.importInfo.onNop(node.getPath());
            }
        }
        return node;
    }

    private boolean ensureCheckedOut(Node node) throws RepositoryException {
        if (node.isNodeType("mix:versionable") && !node.isCheckedOut()) {
            this.importInfo.registerToVersion(node.getUUID());
            try {
                node.checkout();
                return true;
            }
            catch (RepositoryException e) {
                log.warn("error while checkout node (ignored)", (Throwable)e);
            }
        }
        return false;
    }

    private Node createNode(Node currentNode, String name, Collection<DocViewProperty> props) throws RepositoryException {
        try {
            ContentHandler handler = this.session.getImportContentHandler(currentNode.getPath(), 1);
            String[] prefixes = this.session.getNamespacePrefixes();
            handler.startDocument();
            for (String prefix : prefixes) {
                handler.startPrefixMapping(prefix, this.session.getNamespaceURI(prefix));
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", name);
            handler.startElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node", attrs);
            for (DocViewProperty p : props) {
                if (p == null || p.values == null || !PROTECTED_PROPERTIES.contains(p.name)) continue;
                attrs = new AttributesImpl();
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "name", "sv:name", "CDATA", p.name);
                attrs.addAttribute("http://www.jcp.org/jcr/sv/1.0", "type", "sv:type", "CDATA", "undefined");
                handler.startElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property", attrs);
                for (String v : p.values) {
                    handler.startElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value", EMPTY_ATTRIBUTES);
                    handler.characters(v.toCharArray(), 0, v.length());
                    handler.endElement("http://www.jcp.org/jcr/sv/1.0", "value", "sv:value");
                }
                handler.endElement("http://www.jcp.org/jcr/sv/1.0", "property", "sv:property");
            }
            handler.endElement("http://www.jcp.org/jcr/sv/1.0", "node", "sv:node");
            handler.endDocument();
            Node node = currentNode.getNode(name);
            for (DocViewProperty p : props) {
                if (p == null || p.values == null || PROTECTED_PROPERTIES.contains(p.name)) continue;
                try {
                    p.apply(node);
                }
                catch (RepositoryException e) {
                    log.warn("Error while setting property (ignore): " + (Object)((Object)e));
                }
            }
            return node;
        }
        catch (SAXException e) {
            Exception root = e.getException();
            if (root instanceof RepositoryException) {
                throw (RepositoryException)((Object)root);
            }
            if (root instanceof RuntimeException) {
                throw (RuntimeException)root;
            }
            throw new RepositoryException("Error while creating node", (Throwable)root);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        log.debug("<- element {}", (Object)qName);
        try {
            if (this.skipped) {
                this.skipped = false;
            } else {
                NodeNameList childNames = this.stack.getChildNames();
                Node node = this.stack.getNode();
                if (node != null) {
                    NodeIterator iter = node.getNodes();
                    while (iter.hasNext()) {
                        Node child = iter.nextNode();
                        String label = Text.getName((String)child.getPath());
                        if (childNames.contains(label) || this.hints.contains(child.getPath()) || !this.isIncluded((Item)child, child.getDepth() - this.rootDepth)) continue;
                        this.importInfo.onDeleted(child.getPath());
                        child.remove();
                    }
                    this.stack.restoreOrder();
                }
                this.stack = this.stack.pop();
                if (this.stack.isRoot()) {
                    this.importInfo.setNameList(childNames);
                    this.importInfo.setNode(node);
                }
            }
        }
        catch (RepositoryException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.session.getNamespaceURI(prefix);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.session.getNamespacePrefix(uri);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    static {
        HashSet<String> props = new HashSet<String>();
        props.add("jcr:primaryType");
        props.add("jcr:mixinTypes");
        props.add("jcr:uuid");
        props.add("jcr:isCheckedOut");
        props.add("jcr:baseVersion");
        props.add("jcr:predecessors");
        props.add("jcr:successors");
        props.add("jcr:versionHistory");
        PROTECTED_PROPERTIES = Collections.unmodifiableSet(props);
    }

    private static class StackElement {
        private final Node node;
        final StackElement parent;
        private final NodeNameList childNames = new NodeNameList();

        public Node getNode() {
            return this.node;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public void addName(String name) {
            this.childNames.addName(name);
        }

        public NodeNameList getChildNames() {
            return this.childNames;
        }

        public void restoreOrder() throws RepositoryException {
            this.childNames.restoreOrder(this.node);
        }

        public StackElement(StackElement parent, Node node) {
            this.node = node;
            this.parent = parent;
        }

        public StackElement push(Node node) {
            return new StackElement(this, node);
        }

        public StackElement pop() {
            return this.parent;
        }
    }

    private static class BlobInfo {
        private final boolean isMulti;
        private final List<Artifact> artifacts = new ArrayList<Artifact>();

        public BlobInfo(boolean multi) {
            this.isMulti = multi;
        }

        public boolean isFile() {
            return this.artifacts.size() > 0 && this.artifacts.get(0).getType() == ArtifactType.FILE;
        }

        public void add(Artifact a) {
            assert (this.artifacts.isEmpty());
            this.artifacts.add(a);
        }

        public void add(int idx, Artifact a) {
            while (idx >= this.artifacts.size()) {
                this.artifacts.add(null);
            }
            this.artifacts.set(idx, a);
        }

        public Value[] getValues(Session session) throws RepositoryException, IOException {
            Value[] values = new Value[this.artifacts.size()];
            for (int i = 0; i < values.length; ++i) {
                Artifact a = this.artifacts.get(i);
                values[i] = session.getValueFactory().createValue(a.getInputStream());
            }
            return values;
        }

        public Value getValue(Session session) throws RepositoryException, IOException {
            Artifact a = this.artifacts.get(0);
            return session.getValueFactory().createValue(a.getInputStream());
        }

        public void detach() {
            for (Artifact a : this.artifacts) {
                if (!(a instanceof PropertyValueArtifact)) continue;
                try {
                    ((PropertyValueArtifact)a).detach();
                }
                catch (IOException e) {
                    log.warn("error while detaching property artifact", (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.warn("error while detaching property artifact", (Throwable)e);
                }
            }
        }
    }
}

