/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.ArtifactType;
import com.day.jcr.vault.fs.api.ImportArtifact;
import com.day.jcr.vault.fs.api.ImportInfo;
import com.day.jcr.vault.fs.api.ItemFilterSet;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.AbstractArtifactHandler;
import com.day.jcr.vault.fs.impl.io.DocViewSAXImporter;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import com.day.jcr.vault.util.MimeTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.util.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FileArtifactHandler
extends AbstractArtifactHandler {
    private String xmlNodeType = "nt:xmlDocument";
    private boolean explodeXml = false;

    public String getXmlNodeType() {
        return this.xmlNodeType;
    }

    public void setXmlNodeType(String xmlNodeType) {
        this.xmlNodeType = xmlNodeType;
    }

    public boolean isExplodeXml() {
        return this.explodeXml;
    }

    public void setExplodeXml(boolean explodeXml) {
        this.explodeXml = explodeXml;
    }

    public ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        ImportInfoImpl info = null;
        Collection<Artifact> removed = artifacts.removed();
        for (Artifact a : removed) {
            if (a.getType() != ArtifactType.FILE || !parent.hasNode(a.getRelativePath())) continue;
            Node node = parent.getNode(a.getRelativePath());
            if (info == null) {
                info = new ImportInfoImpl();
            }
            info.onDeleted(node.getPath());
            node.remove();
        }
        if (artifacts.size(ArtifactType.FILE) > 0 || artifacts.size(ArtifactType.BINARY) > 0) {
            VaultInputSource source;
            Artifact primary = artifacts.getPrimaryData();
            if (primary != null && (source = primary.getInputSource()) != null) {
                info = this.importDocView(parent, (InputSource)source, artifacts, wspFilter);
            }
            if (info == null) {
                info = new ImportInfoImpl();
            }
            for (Artifact artifact : artifacts.values(ArtifactType.FILE)) {
                if (artifact.getSerializationType() == SerializationType.GENERIC || artifact.getSerializationType() == SerializationType.XML_GENERIC) {
                    if (!parent.hasNode(artifact.getRelativePath())) {
                        this.importFile(info, parent, artifact);
                        continue;
                    }
                    Node fileNode = parent.getNode(artifact.getRelativePath());
                    if (!(artifact instanceof ImportArtifact)) continue;
                    this.importNtResource(info, fileNode.getNode("jcr:content"), artifact);
                    continue;
                }
                if (artifact.getSerializationType() == SerializationType.XML_DOCVIEW) {
                    String relPath = Text.getRelativeParent((String)artifact.getRelativePath(), (int)1);
                    String newName = Text.getName((String)artifact.getRelativePath());
                    Node newParent = parent;
                    if (relPath.length() > 0) {
                        if (parent.hasNode(relPath)) {
                            newParent = parent.getNode(relPath);
                        } else {
                            throw new IllegalArgumentException("Special docview file can't be imported. parent does not exist: " + parent.getPath() + "/" + relPath);
                        }
                    }
                    ArtifactSetImpl newSet = new ArtifactSetImpl();
                    newSet.setCoverage(ItemFilterSet.INCLUDE_ALL);
                    try {
                        DocViewSAXImporter handler = new DocViewSAXImporter(newParent, newName, newSet, wspFilter);
                        SAXParserFactory factory = SAXParserFactory.newInstance();
                        factory.setNamespaceAware(true);
                        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                        SAXParser parser = factory.newSAXParser();
                        parser.parse((InputSource)artifact.getInputSource(), (DefaultHandler)handler);
                        info = handler.getInfo();
                        continue;
                    }
                    catch (ParserConfigurationException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                    catch (SAXException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
                throw new IllegalArgumentException("Files of type " + artifact.getSerializationType() + " can't be handled by this handler " + this);
            }
            for (Artifact artifact : artifacts.values(ArtifactType.BINARY)) {
                Node parentNode = parent;
                String path = artifact.getRelativePath();
                int idx = path.lastIndexOf(47);
                if (idx > 0) {
                    parentNode = parent.getNode(path.substring(0, idx));
                    path = path.substring(idx + 1);
                }
                parentNode.setProperty(path, artifact.getInputStream());
                info.onModified(path);
                info.onModified(parentNode.getPath());
            }
        }
        return info;
    }

    private Node importFile(ImportInfo info, Node parent, Artifact primary) throws RepositoryException, IOException {
        Node contentNode;
        Node fileNode;
        String name = primary.getRelativePath();
        if (parent.hasNode(name)) {
            fileNode = parent.getNode(name);
            if (!fileNode.isNodeType("nt:file")) {
                parent.refresh(false);
                throw new IOException("Incompatible content. Expected a nt:file but was " + fileNode.getPrimaryNodeType().getName());
            }
            contentNode = fileNode.getNode("jcr:content");
            info.onNop(fileNode.getPath());
        } else {
            fileNode = parent.addNode(name, "nt:file");
            String contentNodeType = primary.getSerializationType() == SerializationType.XML_GENERIC && this.isExplodeXml() ? this.getXmlNodeType() : "nt:resource";
            contentNode = fileNode.addNode("jcr:content", contentNodeType);
            info.onCreated(fileNode.getPath());
            info.onCreated(contentNode.getPath());
        }
        this.importNtResource(info, contentNode, primary);
        return fileNode;
    }

    private ImportInfoImpl importDocView(Node parent, InputSource source, ArtifactSetImpl artifacts, WorkspaceFilter wspFilter) throws RepositoryException, IOException {
        String rootName = artifacts.getPrimaryData().getRelativePath();
        int idx = rootName.indexOf(47);
        if (idx > 0) {
            rootName = rootName.substring(0, idx);
        }
        DocViewSAXImporter handler = new DocViewSAXImporter(parent, rootName, artifacts, wspFilter);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(source, (DefaultHandler)handler);
            return handler.getInfo();
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (SAXException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean importNtResource(ImportInfo info, Node content, Artifact artifact) throws RepositoryException, IOException {
        if (this.explodeXml && !content.isNodeType("nt:resource")) {
            InputStream in = artifact.getInputStream();
            try {
                content.getSession().importXML(content.getPath(), in, 0);
            }
            finally {
                in.close();
            }
        } else {
            Property prop = content.setProperty("jcr:data", artifact.getInputStream());
            if (!content.hasProperty("jcr:mimeType")) {
                String mimeType = artifact.getContentType();
                if (mimeType == null) {
                    mimeType = Text.getName((String)artifact.getRelativePath(), (char)'.');
                    mimeType = MimeTypes.getMimeType((String)mimeType, (String)"application/octet-stream");
                }
                content.setProperty("jcr:mimeType", mimeType);
            }
            Calendar lastMod = Calendar.getInstance();
            if (artifact.getLastModified() != 0L) {
                lastMod.setTimeInMillis(artifact.getLastModified());
            }
            content.setProperty("jcr:lastModified", lastMod);
            if (content.isNew()) {
                info.onCreated(prop.getPath());
                info.onNop(content.getPath());
            } else {
                info.onModified(prop.getPath());
                info.onModified(content.getPath());
            }
        }
        return true;
    }
}

