/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.io;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.SerializationType;
import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.api.WorkspaceFilter;
import com.day.jcr.vault.fs.impl.ArtifactSetImpl;
import com.day.jcr.vault.fs.impl.io.AbstractArtifactHandler;
import com.day.jcr.vault.fs.impl.io.DocViewSAXImporter;
import com.day.jcr.vault.fs.impl.io.ImportInfoImpl;
import java.io.IOException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenericArtifactHandler
extends AbstractArtifactHandler {
    public ImportInfoImpl accept(WorkspaceFilter wspFilter, Node parent, String name, ArtifactSetImpl artifacts) throws RepositoryException, IOException {
        ImportInfoImpl info;
        Artifact primary = artifacts.getPrimaryData();
        if (primary == null) {
            return null;
        }
        VaultInputSource source = primary.getInputSource();
        if (source != null && primary.getSerializationType() == SerializationType.XML_DOCVIEW) {
            try {
                DocViewSAXImporter handler = new DocViewSAXImporter(parent, name, artifacts, wspFilter);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputSource)source, (DefaultHandler)handler);
                info = handler.getInfo();
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (SAXException e) {
                throw new RepositoryException((Throwable)e);
            }
        } else {
            return null;
        }
        return info;
    }
}

