/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.impl.nodetype.jcr20;

import com.day.jcr.vault.fs.ProgressTracker;
import com.day.jcr.vault.fs.api.ProgressTrackerListener;
import com.day.jcr.vault.fs.nodetype.DefaultNodeTypeSet;
import com.day.jcr.vault.fs.nodetype.NodeTypeInstaller;
import com.day.jcr.vault.fs.nodetype.NodeTypeSet;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeDefinitionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrNodeTypeInstaller
implements NodeTypeInstaller {
    private static final Logger log = LoggerFactory.getLogger(JcrNodeTypeInstaller.class);
    private final Session session;

    public JcrNodeTypeInstaller(Session session) {
        this.session = session;
    }

    @Override
    public Collection<NodeType> install(ProgressTracker tracker, NodeTypeSet types) throws IOException, RepositoryException {
        Map pfxToURI;
        NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
        DefaultNodeTypeSet set = types instanceof DefaultNodeTypeSet ? (DefaultNodeTypeSet)types : new DefaultNodeTypeSet(types);
        log.debug("Removing registered nodetypes");
        DefaultNamePathResolver npResolver = new DefaultNamePathResolver(this.session);
        NodeTypeIterator iter = ntMgr.getAllNodeTypes();
        while (iter.hasNext()) {
            NodeType nt = iter.nextNodeType();
            set.remove(npResolver.getQName(nt.getName()));
        }
        ProgressTrackerListener.Mode mode = null;
        if (tracker != null) {
            mode = tracker.setMode(ProgressTrackerListener.Mode.TEXT);
        }
        if (!(pfxToURI = set.getNamespaceMapping().getPrefixToURIMapping()).isEmpty()) {
            for (Object o : pfxToURI.keySet()) {
                String prefix = (String)o;
                String uri = (String)pfxToURI.get(prefix);
                try {
                    this.session.getNamespacePrefix(uri);
                    this.track(tracker, "-", prefix + " -> " + uri);
                }
                catch (RepositoryException e) {
                    this.session.getWorkspace().getNamespaceRegistry().registerNamespace(prefix, uri);
                    this.track(tracker, "A", prefix + " -> " + uri);
                }
            }
        }
        NodeTypeDefinitionFactory fac = new NodeTypeDefinitionFactory(this.session);
        List nodeTypes = fac.create(set.getNodeTypes().values());
        ntMgr.registerNodeTypes(nodeTypes.toArray(new NodeTypeDefinition[nodeTypes.size()]), true);
        for (QNodeTypeDefinition t : set.getRemoved().values()) {
            String name = npResolver.getJCRName(t.getName());
            this.track(tracker, "-", name);
        }
        LinkedList<NodeType> nts = new LinkedList<NodeType>();
        for (QNodeTypeDefinition t : set.getNodeTypes().values()) {
            String name = npResolver.getJCRName(t.getName());
            this.track(tracker, "A", name);
            nts.add(this.session.getWorkspace().getNodeTypeManager().getNodeType(name));
        }
        if (tracker != null) {
            tracker.setMode(mode);
        }
        return nts;
    }

    private void track(ProgressTracker tracker, String action, String path) {
        log.info("{} {}", (Object)action, (Object)path);
        if (tracker != null) {
            tracker.track(action, path);
        }
    }
}

