/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.config.ExportRoot;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.Archive;
import com.day.jcr.vault.util.FileInputSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;

public class FileArchive
implements Archive {
    private final File file;
    private ExportRoot eRoot;
    private OsEntry jcrRoot;

    public FileArchive(File file) {
        this.file = file;
    }

    public void open(boolean strict) throws IOException {
        this.eRoot = ExportRoot.findRoot(this.file);
        if (!this.eRoot.isValid()) {
            throw new IOException("No jcr_root found.");
        }
        this.jcrRoot = new OsEntry(this.eRoot.getJcrRoot());
    }

    public void close() {
        this.eRoot = null;
        this.jcrRoot = null;
    }

    public Archive.Entry getJcrRoot() {
        return this.jcrRoot;
    }

    public MetaInf getMetaInf() {
        return this.eRoot.getMetaInf();
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        File file;
        File file2 = file = entry == null ? null : ((OsEntry)entry).file;
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        return FileUtils.openInputStream((File)file);
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        File file;
        File file2 = file = entry == null ? null : ((OsEntry)entry).file;
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        return new FileInputSource(file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OsEntry
    implements Archive.Entry {
        private final File file;

        private OsEntry(File file) {
            this.file = file;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        public Collection<Archive.Entry> getChildren() {
            File[] files = this.file.listFiles();
            if (files == null || files.length == 0) {
                return null;
            }
            ArrayList<Archive.Entry> ret = new ArrayList<Archive.Entry>(files.length);
            for (File file : files) {
                ret.add(new OsEntry(file));
            }
            return ret;
        }

        @Override
        public Archive.Entry getChild(String name) {
            File child = new File(this.file, name);
            return child.exists() ? new OsEntry(child) : null;
        }
    }
}

