/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.VaultFile;
import com.day.jcr.vault.fs.io.AbstractExporter;
import com.day.jcr.vault.util.NoCloseOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;

public class JarExporter
extends AbstractExporter {
    private JarOutputStream jOut;
    private OutputStream out;
    private File jarFile;

    public JarExporter(File jarFile) {
        this.jarFile = jarFile;
    }

    public JarExporter(OutputStream out) {
        this.out = out;
    }

    public void export(VaultFile vaultFile) throws RepositoryException, IOException {
        this.export(vaultFile, false);
    }

    public void open() throws IOException {
        if (this.jOut == null) {
            if (this.jarFile != null) {
                this.jOut = new JarOutputStream(new FileOutputStream(this.jarFile));
            } else if (this.out != null) {
                this.jOut = new JarOutputStream(this.out);
            } else {
                throw new IllegalArgumentException("Either out or jarFile needs to be set.");
            }
        }
    }

    public void export(VaultFile vaultFile, boolean noClose) throws RepositoryException, IOException {
        this.open();
        super.export(vaultFile);
        if (!noClose) {
            this.close();
        }
    }

    public void createDirectory(VaultFile file, String relPath) throws RepositoryException, IOException {
        ZipEntry e = new ZipEntry(this.getPlatformFilePath(file, relPath) + "/");
        this.jOut.putNextEntry(e);
        this.jOut.closeEntry();
    }

    public void createDirectory(String relPath) throws IOException {
        ZipEntry e = new ZipEntry(relPath + "/");
        this.jOut.putNextEntry(e);
        this.jOut.closeEntry();
    }

    public void writeFile(VaultFile file, String relPath) throws RepositoryException, IOException {
        ZipEntry e = new ZipEntry(this.getPlatformFilePath(file, relPath));
        Artifact a = file.getArtifact();
        if (a.getLastModified() > 0L) {
            e.setTime(a.getLastModified());
        }
        if (this.tracker != null) {
            this.tracker.track("A", relPath);
        }
        this.jOut.putNextEntry(e);
        switch (a.getPreferredAccess()) {
            case NONE: {
                throw new RepositoryException("Artifact has no content.");
            }
            case SPOOL: {
                NoCloseOutputStream nout = new NoCloseOutputStream((OutputStream)this.jOut);
                a.spool((OutputStream)nout);
                break;
            }
            case STREAM: {
                NoCloseOutputStream nout = new NoCloseOutputStream((OutputStream)this.jOut);
                InputStream in = a.getInputStream();
                IOUtils.copy((InputStream)in, (OutputStream)nout);
                in.close();
            }
        }
        this.jOut.closeEntry();
    }

    public void writeFile(InputStream in, String relPath) throws IOException {
        ZipEntry e = new ZipEntry(relPath);
        this.jOut.putNextEntry(e);
        NoCloseOutputStream nout = new NoCloseOutputStream((OutputStream)this.jOut);
        IOUtils.copy((InputStream)in, (OutputStream)nout);
        in.close();
        this.jOut.closeEntry();
    }

    public void write(ZipFile zip, ZipEntry entry) throws IOException {
        if (this.tracker != null) {
            this.tracker.track("A", entry.getName());
        }
        ZipEntry copy = new ZipEntry(entry);
        this.jOut.putNextEntry(copy);
        if (!entry.isDirectory()) {
            InputStream in = zip.getInputStream(entry);
            IOUtils.copy((InputStream)in, (OutputStream)this.jOut);
            in.close();
        }
        this.jOut.closeEntry();
    }

    public void close() throws IOException {
        if (this.jOut != null) {
            this.jOut.close();
            this.jOut = null;
        }
    }
}

