/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.Artifact;
import com.day.jcr.vault.fs.api.VaultFile;
import com.day.jcr.vault.fs.io.AbstractExporter;
import com.day.jcr.vault.util.PathUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PlatformExporter
extends AbstractExporter {
    private final File localParent;
    private boolean pruneMissing;
    private Set<File> existing;

    public PlatformExporter(File localFile) {
        this.localParent = localFile;
    }

    public boolean pruneMissing() {
        return this.pruneMissing;
    }

    public void setPruneMissing(boolean pruneMissing) {
        this.pruneMissing = pruneMissing;
    }

    public void export(VaultFile vaultFile) throws RepositoryException, IOException {
        if (this.pruneMissing) {
            this.existing = new LinkedHashSet<File>();
            this.scan(new File(this.localParent, "jcr_root"));
        }
        super.export(vaultFile);
        if (this.pruneMissing) {
            for (File file : this.existing) {
                if (this.tracker == null) continue;
                String path = file.getPath();
                FileUtils.deleteQuietly((File)file);
                this.tracker.track("D", PathUtil.getRelativePath((String)this.localParent.getAbsolutePath(), (String)path));
            }
        }
    }

    private void scan(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = file.getName();
            if (name.equals(".svn") || name.equals(".vlt")) continue;
            this.existing.add(file);
            if (!file.isDirectory()) continue;
            this.scan(file);
        }
    }

    public void createDirectory(VaultFile file, String relPath) throws RepositoryException, IOException {
        File dir = new File(this.localParent, this.getPlatformFilePath(file, relPath));
        this.mkdirs(dir);
    }

    public void createDirectory(String relPath) throws IOException {
        File dir = new File(this.localParent, relPath);
        this.mkdirs(dir);
    }

    public void writeFile(VaultFile file, String relPath) throws RepositoryException, IOException {
        File local = new File(this.localParent, this.getPlatformFilePath(file, relPath));
        if (!local.getParentFile().exists()) {
            this.mkdirs(local.getParentFile());
        }
        if (this.existing != null) {
            this.existing.remove(local);
        }
        if (this.tracker != null) {
            this.tracker.track("A", PathUtil.getRelativeFilePath((String)this.localParent.getAbsolutePath(), (String)local.getAbsolutePath()));
        }
        Artifact a = file.getArtifact();
        switch (a.getPreferredAccess()) {
            case NONE: {
                throw new RepositoryException("Artifact has no content.");
            }
            case SPOOL: {
                FileOutputStream out = new FileOutputStream(local);
                a.spool((OutputStream)out);
                out.close();
                break;
            }
            case STREAM: {
                InputStream in = a.getInputStream();
                FileOutputStream out = new FileOutputStream(local);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                in.close();
                out.close();
            }
        }
        if (a.getLastModified() >= 0L) {
            local.setLastModified(a.getLastModified());
        }
    }

    private void mkdirs(File dir) throws IOException {
        dir.mkdirs();
        if (this.existing != null) {
            while (!dir.equals(this.localParent)) {
                this.existing.remove(dir);
                dir = dir.getParentFile();
            }
        }
    }

    public void writeFile(InputStream in, String relPath) throws IOException {
        File local = new File(this.localParent, relPath);
        if (!local.getParentFile().exists()) {
            this.mkdirs(local.getParentFile());
        }
        if (this.existing != null) {
            this.existing.remove(local);
        }
        FileOutputStream out = new FileOutputStream(local);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
    }
}

