/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.io;

import com.day.jcr.vault.fs.api.VaultInputSource;
import com.day.jcr.vault.fs.config.MetaInf;
import com.day.jcr.vault.fs.io.Archive;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipStreamArchive
implements Archive {
    private static final Logger log = LoggerFactory.getLogger(ZipStreamArchive.class);
    private final File zipFile;
    private final String virtualRoot;
    private File tmpFile;
    private RandomAccessFile raf;
    private JarEntry root;

    public ZipStreamArchive(File zipFile, String virtualRoot) {
        this.zipFile = zipFile;
        this.virtualRoot = virtualRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean strict) throws IOException {
        if (this.raf != null) {
            throw new IllegalStateException("already open");
        }
        this.tmpFile = File.createTempFile("__vlttmpbuffer", ".dat");
        this.raf = new RandomAccessFile(this.tmpFile, "rw");
        int pfxLen = this.virtualRoot == null ? 0 : this.virtualRoot.length();
        JarEntry root = new JarEntry("");
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.zipFile)));
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                String[] names;
                String name = entry.getName();
                if (this.virtualRoot != null) {
                    if (!name.startsWith(this.virtualRoot)) continue;
                    name = name.substring(pfxLen);
                }
                if (name.startsWith("META-INF") || (names = Text.explode((String)name, (int)47)).length <= 0) continue;
                JarEntry je = root;
                for (int i = 0; i < names.length; ++i) {
                    if (i == names.length - 1 && !entry.isDirectory()) {
                        long pos = this.raf.getFilePointer();
                        long len = this.copy(zin);
                        je = je.add(new JarEntry(names[i], entry.getTime(), pos, len));
                        continue;
                    }
                    je = je.add(names[i]);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("scanning jar: {}", (Object)name);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zin);
        }
        if (this.virtualRoot == null && (root = (JarEntry)root.getChild("jcr_root")) == null) {
            throw new IOException("No jcr_root found.");
        }
        this.root = root;
    }

    private long copy(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        int total = 0;
        while ((read = in.read(buffer)) > 0) {
            this.raf.write(buffer, 0, read);
            total += read;
        }
        return total;
    }

    public InputStream openInputStream(Archive.Entry entry) throws IOException {
        return new RafInputStream((JarEntry)entry);
    }

    public VaultInputSource getInputSource(Archive.Entry entry) throws IOException {
        return new RafInputSource((JarEntry)entry);
    }

    public MetaInf getMetaInf() {
        throw new IllegalStateException("getMetaInf() should not be called directly.");
    }

    public void close() {
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raf = null;
        }
        if (this.tmpFile != null) {
            FileUtils.deleteQuietly((File)this.tmpFile);
            this.tmpFile = null;
        }
    }

    public Archive.Entry getJcrRoot() {
        return this.root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarEntry
    implements Archive.Entry {
        public final String name;
        public final long date;
        public final long pos;
        public final long len;
        public Map<String, JarEntry> children;

        private JarEntry(String name) {
            this.name = name;
            this.date = 0L;
            this.pos = -1L;
            this.len = 0L;
        }

        private JarEntry(String name, long date, long pos, long len) {
            this.name = name;
            this.date = date;
            this.pos = pos;
            this.len = len;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isDirectory() {
            return this.pos < 0L;
        }

        public JarEntry add(JarEntry e) {
            if (this.children == null) {
                this.children = new HashMap<String, JarEntry>();
            }
            this.children.put(e.getName(), e);
            return e;
        }

        public JarEntry add(String name) {
            JarEntry e;
            if (this.children == null) {
                this.children = new HashMap<String, JarEntry>();
            } else {
                e = this.children.get(name);
                if (e != null) {
                    return e;
                }
            }
            e = new JarEntry(name);
            this.children.put(name, e);
            return e;
        }

        @Override
        public Collection<? extends Archive.Entry> getChildren() {
            return this.children == null ? Collections.emptyList() : this.children.values();
        }

        @Override
        public Archive.Entry getChild(String name) {
            return this.children == null ? null : this.children.get(name);
        }
    }

    private class RafInputStream
    extends InputStream {
        private long pos;
        private long end;
        private long mark;

        private RafInputStream(JarEntry entry) {
            this.pos = entry.pos;
            this.end = this.pos + entry.len;
        }

        public int read() throws IOException {
            if (this.pos < this.end) {
                ZipStreamArchive.this.raf.seek(this.pos++);
                return ZipStreamArchive.this.raf.read();
            }
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.pos >= this.end) {
                return -1;
            }
            len = Math.min(len, (int)(this.end - this.pos));
            ZipStreamArchive.this.raf.seek(this.pos);
            int read = ZipStreamArchive.this.raf.read(b, off, len);
            if (read < 0) {
                return -1;
            }
            this.pos += (long)read;
            return read;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public long skip(long n) throws IOException {
            if (this.pos >= this.end) {
                return -1L;
            }
            n = Math.min(n, this.end - this.pos);
            this.pos += n;
            return n;
        }

        public int available() throws IOException {
            return (int)(this.end - this.pos);
        }

        public void close() throws IOException {
        }

        public void mark(int readlimit) {
            this.mark = this.pos;
        }

        public void reset() throws IOException {
            this.pos = this.mark;
        }

        public boolean markSupported() {
            return true;
        }
    }

    private class RafInputSource
    extends VaultInputSource {
        private final JarEntry entry;

        private RafInputSource(JarEntry entry) {
            this.entry = entry;
        }

        public InputStream getByteStream() {
            return new RafInputStream(this.entry);
        }

        public long getContentLength() {
            return this.entry.len;
        }

        public long getLastModified() {
            return this.entry.date;
        }
    }
}

