/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.fs.nodetype;

import com.day.jcr.vault.fs.nodetype.CNDReader;
import com.day.jcr.vault.fs.nodetype.CNDWriter;
import com.day.jcr.vault.fs.nodetype.NodeTypeInstaller;
import java.io.Writer;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeHandling {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeHandling.class);
    private static Boolean hasReader;
    private static final String CLASS_JCR_NODE_TYPE_DEFINITION = "javax.jcr.nodetype.NodeTypeDefinition";
    private static final String CLASS_JCR20_READER = "com.day.jcr.vault.fs.impl.nodetype.jcr20.DefaultCNDReader";
    private static final String CLASS_JCR10_READER = "com.day.jcr.vault.fs.impl.nodetype.jcr10.DefaultCNDReader";
    private static final String CLASS_JCR20_WRITER = "com.day.jcr.vault.fs.impl.nodetype.jcr20.DefaultCNDWriter";
    private static final String CLASS_JCR10_WRITER = "com.day.jcr.vault.fs.impl.nodetype.jcr10.DefaultCNDWriter";
    private static final String CLASS_JCR20_INSTALLER = "com.day.jcr.vault.fs.impl.nodetype.jcr20.JcrNodeTypeInstaller";
    private static final String CLASS_JCR10_INSTALLER = "com.day.jcr.vault.fs.impl.nodetype.jcr20.JackrabbitCNDInstaller";

    public static boolean hasSpiCommonsReader() {
        if (hasReader == null) {
            try {
                NodeTypeHandling.class.getClassLoader().loadClass(CLASS_JCR_NODE_TYPE_DEFINITION);
                log.info("javax.jcr.nodetype.NodeTypeDefinition detected. Assuming JCR 2.0");
                hasReader = true;
            }
            catch (ClassNotFoundException e) {
                log.info("No javax.jcr.nodetype.NodeTypeDefinition detected. Assuming JCR 1.0.");
                hasReader = false;
            }
        }
        return hasReader;
    }

    public static CNDReader getCNDReader() {
        String clsName = NodeTypeHandling.hasSpiCommonsReader() ? CLASS_JCR20_READER : CLASS_JCR10_READER;
        try {
            Class<?> cls = NodeTypeHandling.class.getClassLoader().loadClass(clsName);
            return (CNDReader)cls.newInstance();
        }
        catch (Exception e) {
            log.error("Unable to load class {}: {}", (Object)clsName, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public static NodeTypeInstaller getDefaultInstaller(Session session) {
        String clsName = NodeTypeHandling.hasSpiCommonsReader() ? CLASS_JCR20_INSTALLER : CLASS_JCR10_INSTALLER;
        try {
            Class<?> cls = NodeTypeHandling.class.getClassLoader().loadClass(clsName);
            return (NodeTypeInstaller)cls.getConstructor(Session.class).newInstance(session);
        }
        catch (Exception e) {
            log.error("Unable to load class {}: {}", (Object)clsName, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    public static CNDWriter getCNDWriter(Writer out, Session s, boolean includeNS) {
        String clsName = NodeTypeHandling.hasSpiCommonsReader() ? CLASS_JCR20_WRITER : CLASS_JCR10_WRITER;
        try {
            Class<?> cls = NodeTypeHandling.class.getClassLoader().loadClass(clsName);
            return (CNDWriter)cls.getConstructor(Writer.class, Session.class, Boolean.TYPE).newInstance(out, s, includeNS);
        }
        catch (Exception e) {
            log.error("Unable to load class {}: {}", (Object)clsName, (Object)e);
            throw new IllegalStateException(e);
        }
    }
}

