/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.amf;

import com.exadel.flamingo.flex.amf.AMF3Object;
import flex.messaging.messages.Message;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class AMF0Body
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String target;
    protected String serviceName;
    protected String serviceMethodName;
    protected String response;
    protected Object value;
    protected byte type;
    public static final byte DATA_TYPE_UNKNOWN = -1;
    public static final byte DATA_TYPE_NUMBER = 0;
    public static final byte DATA_TYPE_BOOLEAN = 1;
    public static final byte DATA_TYPE_STRING = 2;
    public static final byte DATA_TYPE_OBJECT = 3;
    public static final byte DATA_TYPE_MOVIE_CLIP = 4;
    public static final byte DATA_TYPE_NULL = 5;
    public static final byte DATA_TYPE_UNDEFINED = 6;
    public static final byte DATA_TYPE_REFERENCE_OBJECT = 7;
    public static final byte DATA_TYPE_MIXED_ARRAY = 8;
    public static final byte DATA_TYPE_OBJECT_END = 9;
    public static final byte DATA_TYPE_ARRAY = 10;
    public static final byte DATA_TYPE_DATE = 11;
    public static final byte DATA_TYPE_LONG_STRING = 12;
    public static final byte DATA_TYPE_AS_OBJECT = 13;
    public static final byte DATA_TYPE_RECORDSET = 14;
    public static final byte DATA_TYPE_XML = 15;
    public static final byte DATA_TYPE_CUSTOM_CLASS = 16;
    public static final byte DATA_TYPE_AMF3_OBJECT = 17;

    public AMF0Body(String target, String response, Object value) {
        this(target, response, value, -1);
    }

    public AMF0Body(String target, String response, Object value, byte type) {
        this.response = response;
        this.value = value;
        this.type = type;
        this.setTarget(target);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        int dotIndex = target.lastIndexOf(46);
        if (dotIndex > 0) {
            this.serviceName = target.substring(0, dotIndex);
            this.serviceMethodName = target.substring(dotIndex + 1);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceMethodName() {
        return this.serviceMethodName;
    }

    public String getResponse() {
        return this.response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    public boolean isFirstBody() {
        return "/1".equals(this.response);
    }

    public int getBodyIndex() {
        if (this.response != null && this.response.length() > 1) {
            try {
                return Integer.parseInt(this.response.substring(1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public static String getObjectTypeDescription(byte type) {
        switch (type) {
            case -1: {
                return "UNKNOWN";
            }
            case 0: {
                return "NUMBER";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 2: {
                return "STRING";
            }
            case 3: {
                return "OBJECT";
            }
            case 4: {
                return "MOVIECLIP";
            }
            case 5: {
                return "NULL";
            }
            case 6: {
                return "UNDEFINED";
            }
            case 7: {
                return "REFERENCE";
            }
            case 8: {
                return "MIXED_ARRAY";
            }
            case 9: {
                return "OBJECT_END";
            }
            case 10: {
                return "ARRAY";
            }
            case 11: {
                return "DATE";
            }
            case 12: {
                return "LONG_STRING";
            }
            case 13: {
                return "AS_OBJECT";
            }
            case 14: {
                return "RECORDSET";
            }
            case 15: {
                return "XML";
            }
            case 16: {
                return "CUSTOM_CLASS";
            }
            case 17: {
                return "AMF3_OBJECT";
            }
        }
        return "UNKNOWN: 0x" + Integer.toBinaryString(type);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        return new StringBuffer(1024).append('\n').append(indent).append(AMF0Body.class.getName()).append(" {").append('\n').append(indent).append("  target = ").append(this.getTarget()).append('\n').append(indent).append("  serviceName = ").append(this.getServiceName()).append('\n').append(indent).append("  serviceMethodName = ").append(this.getServiceMethodName()).append('\n').append(indent).append("  response = ").append(this.getResponse()).append('\n').append(indent).append("  type = ").append(AMF0Body.getObjectTypeDescription(this.type)).append('\n').append(indent).append("  value = ").append(AMF0Body.printValue(this.value, indent + "  ")).append('\n').append(indent).append('}').toString();
    }

    private static String printValue(Object value, String indent) {
        if (value == null) {
            return "null";
        }
        if (value instanceof AMF3Object) {
            return ((AMF3Object)((Object)value)).toString(indent);
        }
        if (value instanceof Message) {
            return ((Message)((Object)value)).toString(indent);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(value, i));
            }
            value = list;
        }
        if (value instanceof List) {
            List list = value;
            StringBuilder sb = new StringBuilder(512);
            String innerIndent = indent + "  ";
            sb.append('[');
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('\n').append(indent).append("  ").append(AMF0Body.printValue(list.get(i), innerIndent));
            }
            if (list.size() > 0) {
                sb.append('\n').append(indent);
            }
            sb.append(']');
            return sb.toString();
        }
        return ((Object)value).toString();
    }
}

