/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.messaging.amf.io.util;

import com.exadel.flamingo.flex.messaging.amf.io.util.Converter;
import com.exadel.flamingo.flex.messaging.amf.io.util.FieldProperty;
import com.exadel.flamingo.flex.messaging.amf.io.util.JavaClassDescriptor;
import com.exadel.flamingo.flex.messaging.amf.io.util.MapProperty;
import com.exadel.flamingo.flex.messaging.amf.io.util.MethodProperty;
import com.exadel.flamingo.flex.messaging.amf.io.util.Property;
import com.exadel.flamingo.flex.messaging.amf.io.util.UIDProperty;
import com.exadel.flamingo.flex.messaging.amf.io.util.externalizer.Externalizer;
import com.exadel.flamingo.flex.messaging.amf.io.util.instanciator.AbstractInstanciator;
import com.exadel.flamingo.flex.messaging.util.ClassUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class DefaultConverter
implements Converter {
    public Object convertForSerialization(Object value) {
        return value;
    }

    public Object convertForDeserialization(Object value, Type targetType) {
        Class<?> targetClass = ClassUtil.classOfType(targetType);
        if (value == null) {
            if (targetClass.isPrimitive()) {
                if (targetClass == Integer.TYPE) {
                    value = 0;
                } else if (targetClass == Double.TYPE) {
                    value = 0.0;
                } else if (targetClass == Boolean.TYPE) {
                    value = Boolean.FALSE;
                } else if (targetClass == Character.TYPE) {
                    value = Character.valueOf('\u0000');
                } else if (targetClass == Long.TYPE) {
                    value = 0L;
                } else if (targetClass == Byte.TYPE) {
                    value = (byte)0;
                } else if (targetClass == Float.TYPE) {
                    value = Float.valueOf(0.0f);
                } else if (targetClass == Short.TYPE) {
                    value = (short)0;
                }
            }
        } else if (!targetClass.isAssignableFrom(value.getClass())) {
            if (value instanceof Collection) {
                if (Set.class.isAssignableFrom(targetClass)) {
                    value = SortedSet.class.isAssignableFrom(targetClass) ? new TreeSet((Collection)((Object)value)) : new HashSet(value);
                } else if (List.class.isAssignableFrom(targetClass)) {
                    value = new ArrayList(value);
                }
            } else if (value instanceof Number) {
                Number number = (Number)value;
                if (targetClass == Double.class || targetClass == Double.TYPE) {
                    value = number.doubleValue();
                } else if (targetClass == Integer.class || targetClass == Integer.TYPE) {
                    value = number.intValue();
                } else if (targetClass == Long.class || targetClass == Long.TYPE) {
                    value = number.longValue();
                } else if (targetClass == Float.class || targetClass == Float.TYPE) {
                    value = Float.valueOf(number.floatValue());
                } else if (targetClass == Byte.class || targetClass == Byte.TYPE) {
                    value = number.byteValue();
                } else if (targetClass == Short.class || targetClass == Short.TYPE) {
                    value = number.shortValue();
                } else if (targetClass == BigDecimal.class) {
                    value = BigDecimal.valueOf(number.doubleValue());
                } else if (targetClass == BigInteger.class) {
                    value = BigInteger.valueOf(number.longValue());
                }
            } else if (targetClass == Character.class && value.getClass() == String.class && ((String)((Object)value)).length() == 1) {
                value = Character.valueOf(((String)((Object)value)).charAt(0));
            } else if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                if (targetClass.isAssignableFrom(Calendar.class)) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    value = cal;
                } else if (targetClass.isAssignableFrom(Timestamp.class)) {
                    value = new Timestamp(date.getTime());
                } else if (targetClass.isAssignableFrom(Date.class)) {
                    value = new Date(date.getTime());
                } else if (targetClass.isAssignableFrom(Time.class)) {
                    value = new Time(date.getTime());
                }
            } else if (value.getClass().isArray() && List.class.isAssignableFrom(targetClass)) {
                int arrayLength = Array.getLength(value);
                ArrayList<Object> list = new ArrayList<Object>(arrayLength);
                for (int j = 0; j < arrayLength; ++j) {
                    list.add(Array.get(value, j));
                }
                value = list;
            } else if (value instanceof Map && SortedMap.class.isAssignableFrom(targetClass) && !(value instanceof SortedMap)) {
                value = new TreeMap((Map)((Object)value));
            }
        }
        return value;
    }

    protected Object[] convertForDeserialization(Object[] values, Type[] targetTypes) {
        if (values == null) {
            return values;
        }
        Object[] convertedArgs = new Object[values.length];
        for (int i = 0; i < convertedArgs.length; ++i) {
            convertedArgs[i] = this.convertForDeserialization(values[i], targetTypes[i]);
        }
        return convertedArgs;
    }

    protected boolean canConvertForMethodInvocation(Object value, Type targetType) {
        if (value == null) {
            return true;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == targetType) {
            return true;
        }
        Class<?> targetClass = ClassUtil.classOfType(targetType);
        if (targetClass.isAssignableFrom(valueClass)) {
            return true;
        }
        if (targetClass.isPrimitive()) {
            if (valueClass == Integer.class && (targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Boolean.class && targetClass == Boolean.TYPE || valueClass == Long.class && (targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Float.class && (targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Byte.class && (targetClass == Byte.TYPE || targetClass == Short.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Short.class && (targetClass == Short.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Character.class && (targetClass == Character.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE)) {
                return true;
            }
        } else if (Number.class.isAssignableFrom(targetClass)) {
            if (valueClass == Integer.class && (targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Long.class && (targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Float.class && (targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Byte.class && (targetClass == Short.class || targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Short.class && (targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Character.class && (targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class)) {
                return true;
            }
        } else if (valueClass.isArray() && List.class.isAssignableFrom(targetClass)) {
            Class<?> lct;
            Type[] lcts;
            if (targetType instanceof Class) {
                return true;
            }
            if (targetType instanceof ParameterizedType && (lcts = ((ParameterizedType)targetType).getActualTypeArguments()).length == 1 && (lct = ClassUtil.classOfType(lcts[0])).isAssignableFrom(valueClass.getComponentType())) {
                return true;
            }
        }
        return false;
    }

    protected boolean canConvertForMethodInvocation(Object[] values, Type[] targetTypes) {
        boolean canConvert = true;
        for (int i = 0; i < targetTypes.length && canConvert; ++i) {
            canConvert = this.canConvertForMethodInvocation(values[i], targetTypes[i]);
        }
        return canConvert;
    }

    public static class IndexedJavaClassDescriptor {
        private final int index;
        private final JavaClassDescriptor descriptor;

        public IndexedJavaClassDescriptor(int index, JavaClassDescriptor descriptor) {
            this.index = index;
            this.descriptor = descriptor;
        }

        public JavaClassDescriptor getDescriptor() {
            return this.descriptor;
        }

        public int getIndex() {
            return this.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultJavaClassDescriptor
    extends JavaClassDescriptor {
        public DefaultJavaClassDescriptor(Class<?> type) {
            super(type);
        }

        @Override
        protected List<Property> introspectProperties() {
            ArrayList<Property> properties = new ArrayList<Property>();
            Class<?> type = this.getType();
            if (!(this.isExternalizable() || Map.class.isAssignableFrom(type) || Hashtable.class.isAssignableFrom(type))) {
                try {
                    Field[] fields;
                    HashSet<String> propertyNames = new HashSet<String>();
                    BeanInfo info = Introspector.getBeanInfo(type);
                    for (PropertyDescriptor property : info.getPropertyDescriptors()) {
                        String propertyName = property.getName();
                        if (property.getWriteMethod() == null || property.getReadMethod() == null) continue;
                        properties.add(new MethodProperty(this.converter, propertyName, property.getWriteMethod(), property.getReadMethod()));
                        propertyNames.add(propertyName);
                    }
                    for (Field field : fields = type.getFields()) {
                        String propertyName = field.getName();
                        if (propertyNames.contains(propertyName) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                        properties.add(new FieldProperty(this.converter, field.getName(), field));
                        propertyNames.add(propertyName);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return properties;
        }
    }

    public static class DefaultActionScriptClassDescriptor
    extends ActionScriptClassDescriptor {
        public DefaultActionScriptClassDescriptor(String type, byte encoding) {
            super(type, encoding);
        }

        public void defineProperty(String name) {
            if (this.type.length() == 0) {
                this.properties.add(new MapProperty(this.converter, name));
            } else if ("uid".equals(name)) {
                this.properties.add(new UIDProperty(this.converter));
            } else {
                try {
                    PropertyDescriptor[] props;
                    Class<?> clazz = ClassUtil.forName(this.type);
                    BeanInfo info = Introspector.getBeanInfo(clazz);
                    for (PropertyDescriptor prop : props = info.getPropertyDescriptors()) {
                        if (!name.equals(prop.getName()) || prop.getWriteMethod() == null || prop.getReadMethod() == null) continue;
                        this.properties.add(new MethodProperty(this.converter, name, prop.getWriteMethod(), prop.getReadMethod()));
                        return;
                    }
                    Field field = clazz.getField(name);
                    if (!Modifier.isStatic(field.getModifiers()) && !Modifier.isTransient(field.getModifiers())) {
                        this.properties.add(new FieldProperty(this.converter, name, field));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public Object newJavaInstance() {
            if (this.type.length() == 0) {
                return new HashMap();
            }
            String className = this.type;
            try {
                return ClassUtil.newInstance(className);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create instance of: " + className, e);
            }
        }
    }

    public static abstract class ActionScriptClassDescriptor {
        protected final String type;
        protected final byte encoding;
        protected final Externalizer externalizer;
        protected final Converter converter;
        protected final List<Property> properties;

        protected ActionScriptClassDescriptor(String type, byte encoding) {
            this.type = type == null ? "" : type;
            this.encoding = encoding;
            this.externalizer = this.findExternalizer();
            this.converter = new DefaultConverter();
            this.properties = new ArrayList<Property>();
        }

        private Externalizer findExternalizer() {
            if (this.encoding != 1) {
                return null;
            }
            return null;
        }

        public String getType() {
            return this.type;
        }

        public Externalizer getExternalizer() {
            return this.externalizer;
        }

        public byte getEncoding() {
            return this.encoding;
        }

        public boolean isExternalizable() {
            return this.encoding == 1;
        }

        public boolean isDynamic() {
            return this.encoding == 2;
        }

        public abstract void defineProperty(String var1);

        public abstract Object newJavaInstance();

        public int getPropertiesCount() {
            return this.properties.size();
        }

        public String getPropertyName(int index) {
            return this.properties.get(index).getName();
        }

        public void setPropertyValue(int index, Object instance, Object value) {
            Property prop = this.properties.get(index);
            if (value instanceof AbstractInstanciator) {
                ((AbstractInstanciator)value).addReferer(instance, prop);
            } else {
                prop.setProperty(instance, value);
            }
        }

        public void setPropertyValue(String name, Object instance, Object value) {
            MapProperty prop = new MapProperty(this.converter, name);
            if (value instanceof AbstractInstanciator) {
                ((AbstractInstanciator)value).addReferer(instance, prop);
            } else {
                ((Property)prop).setProperty(instance, value);
            }
        }

        public String toString() {
            return this.getClass().getName() + " {\n" + "  type=" + this.type + ",\n" + "  encoding=" + this.encoding + ",\n" + "  externalizer=" + this.externalizer + ",\n" + "  converter=" + this.converter + ",\n" + "  properties=" + this.properties + "\n" + "}";
        }
    }
}

