/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.messaging.amf.io.util;

import com.exadel.flamingo.flex.messaging.amf.io.util.Converter;
import com.exadel.flamingo.flex.messaging.amf.io.util.DefaultConverter;
import com.exadel.flamingo.flex.messaging.amf.io.util.Property;
import com.exadel.flamingo.flex.messaging.amf.io.util.externalizer.Externalizer;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaClassDescriptor {
    protected final Class<?> type;
    protected final String name;
    protected final Externalizer externalizer;
    protected final Converter converter;
    protected final byte encoding;
    protected final List<Property> properties;

    protected JavaClassDescriptor(Class<?> type) {
        this.type = type;
        this.name = JavaClassDescriptor.getClassName(type);
        this.externalizer = null;
        this.converter = new DefaultConverter();
        this.encoding = this.findEncoding(type);
        this.properties = new ArrayList<Property>();
        this.properties.addAll(this.introspectProperties());
    }

    private byte findEncoding(Class<?> type) {
        if (this.externalizer != null || Externalizable.class.isAssignableFrom(type)) {
            return 1;
        }
        if (Map.class.isAssignableFrom(type)) {
            return 2;
        }
        return 0;
    }

    protected abstract List<Property> introspectProperties();

    public static String getClassName(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz)) {
            return "";
        }
        return clazz.getName();
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Externalizer getExternalizer() {
        return this.externalizer;
    }

    public byte getEncoding() {
        return this.encoding;
    }

    public boolean isExternalizable() {
        return this.encoding == 1;
    }

    public boolean isDynamic() {
        return this.encoding == 2;
    }

    public int getPropertiesCount() {
        return this.properties.size();
    }

    public String getPropertyName(int index) {
        return this.properties.get(index).getName();
    }

    public Object getPropertyValue(int index, Object instance) {
        Property prop = this.properties.get(index);
        return prop.getProperty(instance);
    }
}

