/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.seam.amf;

import com.exadel.flamingo.flex.messaging.util.ClassUtil;
import com.exadel.flamingo.flex.messaging.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class ObjectUtil {
    public static Method findServiceMethod(Class objectClass, String methodName, Object[] params) throws NoSuchMethodException {
        Method serviceMethod = null;
        if (params == null || params.length == 0) {
            serviceMethod = objectClass.getMethod(methodName, null);
        } else {
            for (Method method : objectClass.getMethods()) {
                Type[] paramTypes;
                if (!methodName.equals(method.getName()) || (paramTypes = method.getGenericParameterTypes()).length != params.length || !ObjectUtil.canConvertForMethodInvocation(params, paramTypes)) continue;
                serviceMethod = method;
                break;
            }
        }
        if (serviceMethod == null) {
            throw new NoSuchMethodException(objectClass.getName() + '.' + methodName + StringUtil.toString(params));
        }
        return serviceMethod;
    }

    protected static boolean canConvertForMethodInvocation(Object[] values, Type[] targetTypes) {
        boolean canConvert = true;
        for (int i = 0; i < targetTypes.length && canConvert; ++i) {
            canConvert = ObjectUtil.canConvertForMethodInvocation(values[i], targetTypes[i]);
        }
        return canConvert;
    }

    protected static boolean canConvertForMethodInvocation(Object value, Type targetType) {
        if (value == null) {
            return true;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == targetType) {
            return true;
        }
        Class<?> targetClass = ClassUtil.classOfType(targetType);
        if (targetClass.isAssignableFrom(valueClass)) {
            return true;
        }
        if (targetClass.isPrimitive()) {
            if (valueClass == Integer.class && (targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Boolean.class && targetClass == Boolean.TYPE || valueClass == Long.class && (targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Float.class && (targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Byte.class && (targetClass == Byte.TYPE || targetClass == Short.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Short.class && (targetClass == Short.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Character.class && (targetClass == Character.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE)) {
                return true;
            }
        } else if (Number.class.isAssignableFrom(targetClass)) {
            if (valueClass == Integer.class && (targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Long.class && (targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Float.class && (targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Byte.class && (targetClass == Short.class || targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Short.class && (targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Character.class && (targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class)) {
                return true;
            }
        } else if (valueClass.isArray() && List.class.isAssignableFrom(targetClass)) {
            Class<?> lct;
            Type[] lcts;
            if (targetType instanceof Class) {
                return true;
            }
            if (targetType instanceof ParameterizedType && (lcts = ((ParameterizedType)targetType).getActualTypeArguments()).length == 1 && (lct = ClassUtil.classOfType(lcts[0])).isAssignableFrom(valueClass.getComponentType())) {
                return true;
            }
        }
        return false;
    }
}

