/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsAESKey;
import com.fortanix.sdkms.jce.provider.SecurityObjectParameterSpec;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsAes;
import com.fortanix.sdkms.jce.provider.util.ProviderConstants;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.slf4j.LoggerFactory;

public final class AESKeyGenerator
extends KeyGeneratorSpi {
    private int keySize = 16;
    private List<KeyOperations> allowedKeyOperation;
    private boolean isTransientKey = true;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(AESKeyGenerator.class));

    @Override
    protected void engineInit(SecureRandom random) {
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        LOGGER.debug("AESKeyGenerator: init with keysize " + keysize);
        if (keysize % 8 != 0 || !this.isKeySizeValid(keysize / 8)) {
            throw new InvalidParameterException("Wrong key size: must be equal to 128, 192 or 256");
        }
        this.keySize = keysize;
    }

    private boolean isKeySizeValid(int len) {
        for (int i = 0; i < ProviderConstants.AES_KEYSIZES.length; ++i) {
            if (len != ProviderConstants.AES_KEYSIZES[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        LOGGER.debug("AESKeyGenerator: generate");
        KeyObject keyObject = SdkmsAes.generateKeyForAesOperation(this.keySize, this.allowedKeyOperation, this.isTransientKey);
        return new SdkmsAESKey(keyObject);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        LOGGER.debug("AESKeyGenerator: init with params");
        if (!(params instanceof SecurityObjectParameterSpec)) {
            throw new InvalidAlgorithmParameterException("instance is not type of SecurityObjectParameterSpec");
        }
        this.allowedKeyOperation = ((SecurityObjectParameterSpec)params).getAllowedKeyOperations();
        this.isTransientKey = ((SecurityObjectParameterSpec)params).getIsTransientKey();
    }
}

