/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsAESKey;
import com.fortanix.sdkms.jce.provider.SecurityObjectKeySpec;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsAes;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.LoggerFactory;

public class AESSecretKeyFactory
extends SecretKeyFactorySpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(AESSecretKeyFactory.class));
    private static final String ALGO_PATTERN = "(?i)AES|AES_128|AES_192|AES_256";
    private static final String ERROR_MESSAGE = "Invalid algorithm is provided. Supported algorithms are AES, AES_128, AES_192, AES_256";
    private List<KeyOperations> allowedKeyOperations;
    private String alias;

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        byte[] material;
        LOGGER.debug("AES KeyFactory: import using keyspec");
        if (!(keySpec instanceof SecretKeySpec) && !(keySpec instanceof SecurityObjectKeySpec)) {
            throw new InvalidKeySpecException("Unsupported key spec. Supported KeySpec are SecretKeySpec and SecurityObjectKeySpec");
        }
        KeySpec wrappedKeySpec = keySpec;
        if (keySpec instanceof SecurityObjectKeySpec) {
            this.allowedKeyOperations = ((SecurityObjectKeySpec)keySpec).getAllowedKeyOperations();
            this.alias = ((SecurityObjectKeySpec)keySpec).getAlias();
            wrappedKeySpec = ((SecurityObjectKeySpec)keySpec).getKeySpec();
        }
        if ((material = ((SecretKeySpec)wrappedKeySpec).getEncoded()) == null) {
            throw new InvalidKeySpecException("Key material not provided");
        }
        String algorithm = ((SecretKeySpec)wrappedKeySpec).getAlgorithm();
        int keySize = this.extractKeySize(material);
        KeyObject keyObject = SdkmsAes.importAESKey(material, keySize, this.allowedKeyOperations, this.alias);
        return new SdkmsAESKey(keyObject);
    }

    @Override
    protected KeySpec engineGetKeySpec(SecretKey key, Class<?> keySpec) throws InvalidKeySpecException {
        LOGGER.debug("AES KeyFactory: get key spec");
        if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
            return new SecretKeySpec(key.getEncoded(), key.getAlgorithm());
        }
        throw new InvalidKeySpecException("Inappropriate key specification");
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        LOGGER.debug("AES KeyFactory: translate key");
        try {
            if (key != null && key.getAlgorithm().matches(ALGO_PATTERN)) {
                if (key instanceof SdkmsAESKey) {
                    return key;
                }
                KeySpec keySpec = this.engineGetKeySpec(key, SecretKeySpec.class);
                return this.engineGenerateSecret(keySpec);
            }
            throw new InvalidKeyException(ERROR_MESSAGE);
        }
        catch (InvalidKeySpecException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            return null;
        }
    }

    private int extractKeySize(byte[] material) {
        return material.length * 8;
    }
}

