/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.IPadding;
import com.fortanix.sdkms.jce.provider.NoPadding;
import com.fortanix.sdkms.jce.provider.PKCS5Padding;
import com.fortanix.sdkms.jce.provider.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsCipher;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.util.ProviderConstants;
import com.fortanix.sdkms.v1.model.CipherMode;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.DecryptFinalRequestEx;
import com.fortanix.sdkms.v1.model.DecryptInitRequestEx;
import com.fortanix.sdkms.v1.model.DecryptInitResponse;
import com.fortanix.sdkms.v1.model.DecryptRequestEx;
import com.fortanix.sdkms.v1.model.DecryptUpdateRequestEx;
import com.fortanix.sdkms.v1.model.DecryptUpdateResponse;
import com.fortanix.sdkms.v1.model.EncryptFinalRequestEx;
import com.fortanix.sdkms.v1.model.EncryptInitRequestEx;
import com.fortanix.sdkms.v1.model.EncryptInitResponse;
import com.fortanix.sdkms.v1.model.EncryptRequestEx;
import com.fortanix.sdkms.v1.model.EncryptUpdateRequestEx;
import com.fortanix.sdkms.v1.model.EncryptUpdateResponse;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import com.fortanix.sdkms.v1.model.UnwrapKeyRequestEx;
import com.fortanix.sdkms.v1.model.WrapKeyRequestEx;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.LoggerFactory;

public class CipherCore {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(CipherCore.class));
    private static final List<String> supportedPadding = Arrays.asList("NOPADDING", "PKCS5PADDING", "OAEPPADDING");
    private static final List<Integer> supportedOperation = Arrays.asList(1, 2, 4, 3);
    private static final List<CryptMode> clientSideNoPaddSupport = Arrays.asList(CryptMode.CBCNOPAD, CryptMode.ECB);
    private ByteArrayOutputStream accumulatedAAD = new ByteArrayOutputStream();
    private ByteArrayOutputStream accumulatedBytes = new ByteArrayOutputStream();
    private CryptMode cryptMode;
    private String paddingRaw;
    private IPadding padding;
    private int blockSize;
    private byte[] ivBytes;
    private byte[] lastIvBytes;
    private SdkmsCipherKey lastKeyUsed;
    private boolean requireReInit = false;
    private Integer tagLength;
    private boolean decrypting = false;
    private ObjectType alg;
    private SdkmsCipherKey sdkmsKey;
    private CipherType cipherType;
    private boolean isMultipartInitialized = false;
    private boolean isUpdateStarted = false;
    private byte[] state;

    public CipherCore(ObjectType alg, int blkSize, CipherType cipherType) {
        this.blockSize = blkSize;
        this.alg = alg;
        this.cipherType = cipherType;
    }

    public void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!supportedOperation.contains(opmode)) {
            throw new InvalidAlgorithmParameterException(String.format("Unsupported Operation: %d. Supported Operation are %s", opmode, supportedOperation.toString()));
        }
        if (!(key instanceof SdkmsCipherKey)) {
            throw new InvalidKeyException("The key provided is not a valid SDKMS Key which supports Cipher");
        }
        this.switchCryptMode();
        this.resetFields();
        this.sdkmsKey = (SdkmsCipherKey)((Object)key);
        boolean bl = this.decrypting = opmode == 2 || opmode == 4;
        if (params == null) {
            return;
        }
        if (!(params instanceof GCMParameterSpec) && !(params instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unsupported parameters: " + params);
        }
        if (params instanceof GCMParameterSpec) {
            this.ivBytes = ((GCMParameterSpec)params).getIV();
            this.tagLength = ((GCMParameterSpec)params).getTLen();
            if (!SdkmsCipher.isValidTagLength(this.tagLength)) {
                throw new InvalidAlgorithmParameterException("Unsupported Tag Length value. It must be one of " + SdkmsCipher.supportedGcmTagLength());
            }
            boolean bl2 = this.requireReInit = Arrays.equals(this.ivBytes, this.lastIvBytes) && this.sdkmsKey.getKeyDescriptor().equals((Object)this.lastKeyUsed.getKeyDescriptor()) && !this.decrypting;
            if (this.requireReInit) {
                throw new InvalidAlgorithmParameterException("Cannot reuse iv for GCM encryption");
            }
            this.lastIvBytes = this.ivBytes;
            this.lastKeyUsed = this.sdkmsKey;
            return;
        }
        this.ivBytes = ((IvParameterSpec)params).getIV();
        if (this.ivBytes == null || this.ivBytes.length != this.blockSize) {
            throw new InvalidAlgorithmParameterException("Wrong IV length: must be " + this.blockSize + " bytes long");
        }
        this.requireReInit = false;
    }

    public void init(int opmode, Key key) throws InvalidKeyException {
        try {
            this.init(opmode, key, (AlgorithmParameterSpec)null);
        }
        catch (InvalidAlgorithmParameterException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
        }
    }

    public void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params == null) {
            this.init(opmode, key);
            return;
        }
        AlgorithmParameterSpec paramSpec = null;
        try {
            paramSpec = this.cryptMode == CryptMode.GCM || this.cryptMode == CryptMode.CCM ? params.getParameterSpec(GCMParameterSpec.class) : params.getParameterSpec(IvParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            throw new InvalidAlgorithmParameterException("Invalid Algorithm parameter type expected GCM or IV");
        }
        this.init(opmode, key, paramSpec);
    }

    public void initMultiCore() {
        LOGGER.info(String.format("Initializing multi part cipher for Algorithm: %s and mode: %s", this.alg, this.cryptMode));
        this.isMultipartInitialized = true;
        if (this.decrypting) {
            DecryptInitRequestEx decrytRequest = new DecryptInitRequestEx();
            decrytRequest.iv(this.ivBytes).mode(CipherMode.fromValue((String)this.cryptMode.getValue())).alg(this.alg).key(this.sdkmsKey.getKeyDescriptor());
            if (SdkmsCipher.isGCM(this.cryptMode)) {
                decrytRequest.ad(this.accumulatedAAD.toByteArray());
            }
            DecryptInitResponse decryptResponse = SdkmsCipher.decryptInit(decrytRequest);
            this.setState(decryptResponse.getState());
        } else {
            EncryptInitRequestEx encryptRequest = new EncryptInitRequestEx();
            encryptRequest.iv(this.ivBytes).mode(CipherMode.fromValue((String)this.cryptMode.getValue())).alg(this.alg).key(this.sdkmsKey.getKeyDescriptor());
            if (SdkmsCipher.isGCM(this.cryptMode)) {
                encryptRequest.ad(this.accumulatedAAD.toByteArray());
            }
            EncryptInitResponse encryptResponse = SdkmsCipher.encryptInit(encryptRequest);
            this.setState(encryptResponse.getState());
        }
    }

    public byte[] update(byte[] input, int inputOffset, int inputLen) {
        if (this.requireReInit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.validateParameters();
        switch (this.cipherType) {
            case ONLY_SINGLE_PART: {
                return this.doSinglePartUpdate(input, inputOffset, inputLen);
            }
            case SUPPORTS_MULTIPART: {
                return this.doMultiPartUpdate(input, inputOffset, inputLen);
            }
        }
        return new byte[0];
    }

    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        byte[] outputText = this.update(input, inputOffset, inputLen);
        if (outputText == null || outputText.length == 0) {
            return 0;
        }
        if (outputText.length > output.length - outputOffset) {
            throw new ShortBufferException(String.format("output buffer is too small. Expected size:%d, Actual Size:%d", outputText.length, output.length - outputOffset));
        }
        System.arraycopy(outputText, 0, output, outputOffset, outputText.length);
        return outputText.length;
    }

    private byte[] doSinglePartUpdate(byte[] input, int inputOffset, int inputLen) {
        this.accumulatedBytes.write(input, inputOffset, inputLen);
        return new byte[0];
    }

    private byte[] doMultiPartUpdate(byte[] input, int inputOffset, int inputLen) {
        if (!this.isMultipartInitialized) {
            this.initMultiCore();
        }
        this.isUpdateStarted = true;
        byte[] inputText = Arrays.copyOfRange(input, inputOffset, inputOffset + inputLen);
        if (this.decrypting) {
            DecryptUpdateRequestEx decryptRequest = new DecryptUpdateRequestEx();
            decryptRequest.cipher(inputText).state(this.state).key(this.sdkmsKey.getKeyDescriptor());
            DecryptUpdateResponse decryptResponse = SdkmsCipher.decryptUpdate(decryptRequest);
            this.setState(decryptResponse.getState());
            return decryptResponse.getPlain();
        }
        EncryptUpdateRequestEx encryptRequest = new EncryptUpdateRequestEx();
        encryptRequest.plain(inputText).state(this.state).key(this.sdkmsKey.getKeyDescriptor());
        EncryptUpdateResponse encryptResponse = SdkmsCipher.encryptUpdate(encryptRequest);
        this.setState(encryptResponse.getState());
        return encryptResponse.getCipher();
    }

    /*
     * Exception decompiling
     */
    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        byte[] blob = this.doFinal(input, inputOffset, inputLen);
        if (output.length - (outputOffset + 1) < blob.length) {
            throw new ShortBufferException("output buffer is too short");
        }
        System.arraycopy(blob, 0, output, outputOffset, blob.length);
        return blob.length;
    }

    protected void prepareDoFinal() {
        if (this.requireReInit) {
            throw new IllegalStateException("Must use either different key or iv for GCM encryption");
        }
        this.validateParameters();
    }

    private byte[] doSinglePartFinal() {
        if (this.accumulatedBytes.size() == 0) {
            return new byte[0];
        }
        if (this.decrypting) {
            DecryptRequestEx decryptRequest = new DecryptRequestEx();
            decryptRequest.iv(this.ivBytes).mode(this.cryptMode).cipher(this.accumulatedBytes.toByteArray()).alg(this.alg).key(this.sdkmsKey.getKeyDescriptor());
            if (SdkmsCipher.isGCM(this.cryptMode)) {
                decryptRequest.ad(this.accumulatedAAD.toByteArray());
            }
            byte[] output = SdkmsCipher.decrypt(this.tagLength, decryptRequest);
            if (!this.isPaddingRequired()) {
                return output;
            }
            return this.padding.unpad(output);
        }
        if (this.isPaddingRequired()) {
            this.padding.pad(this.accumulatedBytes);
        }
        EncryptRequestEx encryptRequest = new EncryptRequestEx();
        encryptRequest.iv(this.ivBytes).tagLen(this.tagLength).mode(this.cryptMode).plain(this.accumulatedBytes.toByteArray()).alg(this.alg).key(this.sdkmsKey.getKeyDescriptor());
        if (SdkmsCipher.isGCM(this.cryptMode)) {
            encryptRequest.ad(this.accumulatedAAD.toByteArray());
        }
        return SdkmsCipher.encrypt(encryptRequest);
    }

    private byte[] doMultiPartFinal(byte[] input, int inputOffset, int inputLen) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        if (this.decrypting) {
            SdkmsCipher.CipherAndTag cipherAndTag = new SdkmsCipher.CipherAndTag(input, inputOffset, inputLen, null);
            if (SdkmsCipher.isGCM(this.cryptMode)) {
                if (input == null || input.length == 0) {
                    LOGGER.logAndRaiseProviderException("Input cannot be empty in final for GCM Mode, since tag is required", null);
                }
                cipherAndTag = SdkmsCipher.extractGCMTag(this.tagLength, input, inputOffset, inputLen);
            }
            if (cipherAndTag.cipherLen != 0) {
                outStream.write(this.update(cipherAndTag.cipher, cipherAndTag.cipherOffset, cipherAndTag.cipherLen));
            }
            DecryptFinalRequestEx decrypt = new DecryptFinalRequestEx();
            decrypt.state(this.state).tag(cipherAndTag.tag).key(this.sdkmsKey.getKeyDescriptor());
            outStream.write(SdkmsCipher.decryptFinal(decrypt));
        } else {
            if (input != null && input.length != 0) {
                outStream.write(this.update(input, inputOffset, inputLen));
            }
            EncryptFinalRequestEx encrypt = new EncryptFinalRequestEx();
            encrypt.state(this.state).tagLen(this.tagLength).key(this.sdkmsKey.getKeyDescriptor());
            outStream.write(SdkmsCipher.encryptFinal(encrypt, this.cryptMode));
        }
        return outStream.toByteArray();
    }

    public void setCryptMode(CryptMode cryptMode) {
        this.cryptMode = cryptMode;
    }

    public void setPadding(String padding) {
        if (padding == null) {
            return;
        }
        if (!supportedPadding.contains(padding.toUpperCase())) {
            throw new ProviderException(String.format("Unsupported padding %s. Supported paddings are %s", padding, supportedPadding.toString()));
        }
        this.paddingRaw = padding;
        this.padding = new PKCS5Padding(this.blockSize);
        if ("NOPADDING".equalsIgnoreCase(this.paddingRaw)) {
            this.padding = new NoPadding(this.blockSize);
        }
    }

    public int getOutputSize(int inputLen) {
        int tagLength;
        int n = tagLength = this.tagLength == null ? 0 : this.tagLength;
        if (this.decrypting) {
            return inputLen + this.blockSize;
        }
        return inputLen + tagLength + this.blockSize;
    }

    public void updateAAD(byte[] src, int offset, int len) {
        this.accumulatedAAD.write(src, offset, len);
        if (this.isMultipartInitialized) {
            throw new IllegalStateException("The Cipher is already initialized. Cannot set the AAD now");
        }
        if (this.isUpdateStarted) {
            throw new IllegalStateException("The Cipher is already activated with update methods. Cannot set the AAD now");
        }
    }

    public byte[] wrap(Key key) throws InvalidKeyException {
        this.validateParameters();
        KeyObject keyObject = null;
        SobjectDescriptor subject = new SobjectDescriptor();
        keyObject = SdkmsKeyService.toKeyObject(key);
        subject.setKid(keyObject.getKid());
        WrapKeyRequestEx wrapKeyRequest = new WrapKeyRequestEx();
        wrapKeyRequest.iv(this.ivBytes).tagLen(this.tagLength).mode(this.cryptMode).subject(subject).alg(this.alg).key(this.sdkmsKey.getKeyDescriptor());
        if (SdkmsCipher.isGCM(this.cryptMode)) {
            wrapKeyRequest.ad(this.accumulatedAAD.toByteArray());
        }
        return SdkmsCipher.wrapKey(wrapKeyRequest);
    }

    public Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        this.validateParameters();
        UnwrapKeyRequestEx keyRequest = new UnwrapKeyRequestEx();
        ObjectType wrappedKeyalgo = SdkmsKeyService.toSDKMSAlgorithm(wrappedKeyAlgorithm);
        String newNameForWrappedKey = UUID.randomUUID().toString();
        keyRequest.iv(this.ivBytes).mode(this.cryptMode).wrappedKey(wrappedKey).objType(wrappedKeyalgo).name(newNameForWrappedKey).alg(this.alg).key(this.sdkmsKey.getKeyDescriptor());
        if (SdkmsCipher.isGCM(this.cryptMode)) {
            keyRequest.ad(this.accumulatedAAD.toByteArray());
        }
        KeyObject keyObject = SdkmsCipher.unwrapKey(this.tagLength, keyRequest);
        return SdkmsKeyService.getKeyFromKeyObject(keyObject, wrappedKeyType == 1);
    }

    public byte[] getIv() {
        return this.ivBytes;
    }

    public String getPadding() {
        return this.paddingRaw;
    }

    public String getOperation() {
        return this.decrypting ? "Decryption" : "Encryption";
    }

    public CryptMode getCryptMode() {
        return this.cryptMode;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public SdkmsCipherKey getKey() {
        return this.sdkmsKey;
    }

    AlgorithmParameters getParameters(String algorithmName) {
        if (this.cryptMode == CryptMode.ECB) {
            return null;
        }
        byte[] iv = this.ivBytes;
        if (iv == null) {
            SecureRandom random = new SecureRandom();
            iv = new byte[this.blockSize];
            if (SdkmsCipher.isGCM(this.cryptMode)) {
                iv = new byte[ProviderConstants.GCM_IV_LEN];
            }
            random.nextBytes(iv);
        }
        AlgorithmParameters params = null;
        AlgorithmParameterSpec spec = new IvParameterSpec(iv);
        if (SdkmsCipher.isGCM(this.cryptMode)) {
            int tagLength = this.tagLength == null ? 128 : this.tagLength;
            algorithmName = CryptMode.GCM.toString();
            spec = new GCMParameterSpec(tagLength, iv);
        }
        try {
            params = AlgorithmParameters.getInstance(algorithmName);
            params.init(spec);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.logAndRaiseProviderException(String.format("Cannot find %s AlgorithmParameters implementation", algorithmName), e);
        }
        catch (InvalidParameterSpecException e) {
            LOGGER.logAndRaiseProviderException(e.getMessage(), e);
        }
        return params;
    }

    protected void validateParameters() {
        if (ObjectType.RSA.equals(this.alg)) {
            return;
        }
        if (this.cryptMode == null) {
            throw new ProviderException("Cipher mode is null");
        }
        if (this.sdkmsKey == null) {
            throw new ProviderException("Sdkms key info is null");
        }
        if (this.cryptMode == CryptMode.ECB) {
            return;
        }
        if (SdkmsCipher.isGCM(this.cryptMode)) {
            if (this.ivBytes == null || this.accumulatedAAD.size() == 0) {
                throw new ProviderException("IV, AAD are mandatory parameters for crypt mode " + this.cryptMode);
            }
            if (!this.decrypting && this.tagLength == null) {
                throw new ProviderException("tag length is mandatory field " + this.cryptMode);
            }
        }
        if (this.ivBytes == null) {
            throw new ProviderException("IV is mandatory parameter for crypt mode " + this.cryptMode);
        }
    }

    protected void switchCryptMode() {
        if ("PKCS5PADDING".equalsIgnoreCase(this.paddingRaw) || this.cryptMode != CryptMode.CBC) {
            return;
        }
        this.setCryptMode(CryptMode.CBCNOPAD);
    }

    protected boolean isPaddingRequired() {
        if (ObjectType.RSA.equals(this.alg)) {
            return false;
        }
        return clientSideNoPaddSupport.contains(this.cryptMode);
    }

    public void setState(byte[] state) {
        if (state == null) {
            throw new ProviderException("Multi part cipher state is null");
        }
        this.state = state;
    }

    protected void resetFields() {
        this.accumulatedAAD.reset();
        this.ivBytes = null;
        this.tagLength = null;
        this.requireReInit = false;
        this.sdkmsKey = null;
        this.state = null;
        this.isUpdateStarted = false;
        this.isMultipartInitialized = false;
        this.accumulatedBytes.reset();
    }

    public static enum CipherType {
        ONLY_SINGLE_PART,
        SUPPORTS_MULTIPART;

    }
}

