/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProviderException;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class Configuration {
    private static final String PROP_PROVIDER_NAME = "provider.name";
    private static final String PROP_PROVIDER_VERSION = "provider.version";
    private static final String PROP_PROVIDER_INFO = "provider.info";
    private static final String PROVIDER_CONFIG_PATH = "/sdkms-jce-provider.properties";
    private static final Long DEFAULT_KEEP_ALIVE = 5000L;
    private static final String ENV_SDKMS_SERVER_URL = "FORTANIX_API_ENDPOINT";
    private static final String ENV_SDKMS_API_KEY = "FORTANIX_API_KEY";
    private static final String ENV_SDKMS_USE_LOCAL_DIGEST = "FORTANIX_USE_LOCAL_DIGEST";
    private static final String ENV_PUBKEY_IMPORT_TRANSIEN = "FORTANIX_PUBKEY_IMPORT_TRANSIENT";
    private static final String ENV_CIPHER_SINGLEPART_ONLY = "FORTANIX_CIPHER_SINGLEPART_ONLY";
    private static final String ENV_AES_ECB_DISABLED = "AES_ECB_DISABLED";
    private static final String ENV_SDKMS_MAX_CONN = "FORTANIX_CONN_MAX";
    private static final String ENV_SDKMS_KEEP_ALIVE = "FORTANIX_CONN_KEEPALIVE";
    private static final String ENV_LOGGING_DEBUG = "FORTANIX_LOG_DEBUG";
    private static final String ENV_LOGGING_API = "FORTANIX_LOG_API";
    private static final String ENV_LOGGING_LOCATION = "FORTANIX_LOG_FOLDER";
    private static final String USER_CONFIG_FILE_PROPERTY = "provider.config";
    private static final String USER_CONFIG_CLASSPATH = "/sdkms.properties";
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(Configuration.class));
    private Properties configuration = new Properties();
    private Properties userConfiguration = new Properties();
    private String apiEndpoint;
    private String apiKey;
    private Boolean cipherSinglePartOnly;
    private static Configuration instance;

    public static Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public static Configuration initialize(String apiKey, String apiEndpoint) {
        instance = new Configuration(apiEndpoint, apiKey);
        return instance;
    }

    public static Configuration initialize(boolean cipherSinglePartOnly) {
        instance = new Configuration();
        Configuration.instance.cipherSinglePartOnly = cipherSinglePartOnly;
        return instance;
    }

    private Configuration(String apiEndpoint, String apiKey) {
        this.loadConfigurations();
        this.apiKey = apiKey;
        this.apiEndpoint = apiEndpoint;
        this.validateProperties();
    }

    private Configuration() {
        this.loadConfigurations();
        this.apiEndpoint = this.getFromPropertyOrEnv(ENV_SDKMS_SERVER_URL);
        this.apiKey = this.getFromPropertyOrEnv(ENV_SDKMS_API_KEY);
        this.validateProperties();
    }

    private void loadConfigurations() {
        InputStream inStream;
        try {
            inStream = Configuration.class.getResourceAsStream(PROVIDER_CONFIG_PATH);
            if (inStream == null) {
                throw new ProviderException("Provider property file not found");
            }
            this.configuration.load(inStream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load configuration file: /sdkms-jce-provider.properties");
            throw new ProviderException("Failed to load provider property file. " + e.getMessage(), e);
        }
        if (System.getProperty(USER_CONFIG_FILE_PROPERTY) != null && !System.getProperty(USER_CONFIG_FILE_PROPERTY).isEmpty()) {
            try {
                File configFile = new File(System.getProperty(USER_CONFIG_FILE_PROPERTY));
                FileInputStream configStream = new FileInputStream(configFile);
                this.userConfiguration.load(configStream);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load configuration file: " + System.getProperty(USER_CONFIG_FILE_PROPERTY), e);
            }
        } else {
            try {
                inStream = Configuration.class.getResourceAsStream(USER_CONFIG_CLASSPATH);
                if (inStream != null) {
                    this.userConfiguration.load(inStream);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load configuration file /sdkms.properties from classpath.", e);
            }
        }
        if (this.getFromPropertyOrEnv(ENV_LOGGING_LOCATION) != null) {
            System.setProperty(ENV_LOGGING_LOCATION, this.getFromPropertyOrEnv(ENV_LOGGING_LOCATION));
        }
    }

    public String getProviderName() {
        return this.configuration.getProperty(PROP_PROVIDER_NAME);
    }

    public String getProviderInfo() {
        return this.configuration.getProperty(PROP_PROVIDER_INFO);
    }

    public Double getProviderVersion() {
        Double version = 0.1;
        try {
            version = Double.parseDouble(this.configuration.getProperty(PROP_PROVIDER_VERSION));
        }
        catch (NumberFormatException ne) {
            LOGGER.warn("provider.version should be an number. setting version to default value " + version);
        }
        return version;
    }

    public boolean isAesEcbDisabled() {
        return "true".equals(this.getFromPropertyOrEnv(ENV_AES_ECB_DISABLED));
    }

    public String getSdkmsApiKey() {
        return this.apiKey;
    }

    public String getSdkmsServerUrl() {
        return this.apiEndpoint;
    }

    public boolean getLocalDigestEnabledFlag() {
        return "true".equals(this.getFromPropertyOrEnv(ENV_SDKMS_USE_LOCAL_DIGEST));
    }

    public int getMaxConn() {
        String maxConn = this.getFromPropertyOrEnv(ENV_SDKMS_MAX_CONN);
        try {
            return Integer.parseInt(maxConn);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public long getKeepAliveDuration() {
        String keepAliveTime = this.getFromPropertyOrEnv(ENV_SDKMS_KEEP_ALIVE);
        try {
            return Long.parseLong(keepAliveTime);
        }
        catch (Exception e) {
            return DEFAULT_KEEP_ALIVE;
        }
    }

    public boolean getTransientPubkeyImportOnlyFlag() {
        return "true".equals(this.getFromPropertyOrEnv(ENV_PUBKEY_IMPORT_TRANSIEN));
    }

    public boolean getCipherSinglePartOnly() {
        if (this.cipherSinglePartOnly == null) {
            this.cipherSinglePartOnly = "true".equals(this.getFromPropertyOrEnv(ENV_CIPHER_SINGLEPART_ONLY));
        }
        return this.cipherSinglePartOnly;
    }

    public boolean isDebugLogging() {
        return "true".equals(this.getFromPropertyOrEnv(ENV_LOGGING_DEBUG));
    }

    public boolean isAPILogging() {
        return "true".equals(this.getFromPropertyOrEnv(ENV_LOGGING_API));
    }

    public String getLogLocation() {
        return this.getFromPropertyOrEnv(ENV_LOGGING_LOCATION);
    }

    private String getFromPropertyOrEnv(String property) {
        if (this.userConfiguration.getProperty(property) != null && !this.userConfiguration.getProperty(property).isEmpty()) {
            return this.userConfiguration.getProperty(property);
        }
        return System.getenv(property);
    }

    private void validateProperties() {
        StringBuilder missingEnv = new StringBuilder();
        if (this.apiEndpoint == null) {
            missingEnv.append(ENV_SDKMS_SERVER_URL).append(",");
        }
        if (this.apiKey == null) {
            missingEnv.append(ENV_SDKMS_API_KEY).append(",");
        }
        if (missingEnv.length() > 0) {
            LOGGER.warn(String.format("Missing Properties: %s", new String(missingEnv)));
        }
    }
}

