/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.CipherCore;
import com.fortanix.sdkms.jce.provider.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.v1.model.CryptMode;
import com.fortanix.sdkms.v1.model.ObjectType;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.slf4j.LoggerFactory;

public abstract class DESCipher
extends CipherSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DESCipher.class));
    CipherCore cipherCore;

    public DESCipher(String mode, String padding, CipherCore.CipherType cipherType) {
        this.cipherCore = new CipherCore(ObjectType.DES, 8, cipherType);
        this.cipherCore.setCryptMode(CryptMode.fromValue((String)mode));
        this.cipherCore.setPadding(padding);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        LOGGER.debug("DESCipher: cipher final");
        return this.cipherCore.doFinal(input, inputOffset, inputLen);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        LOGGER.debug("DESCipher: cipher final");
        return this.cipherCore.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineGetBlockSize() {
        return 8;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipherCore.getIv();
    }

    @Override
    protected int engineGetOutputSize(int inputLength) {
        return this.cipherCore.getOutputSize(inputLength);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey is supported");
        }
        if (key instanceof SdkmsCipherKey) {
            return ((SdkmsCipherKey)((Object)key)).getKeySize();
        }
        throw new InvalidKeyException("Unsupported Key type. Only SdkmsCipherKey is supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.cipherCore.getParameters(ObjectType.DES.toString());
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        LOGGER.debug("DESCipher: cipher init");
        this.cipherCore.init(opmode, key);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        LOGGER.debug("DESCipher: cipher init");
        this.cipherCore.init(opmode, key, params);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        LOGGER.debug("DESCipher: cipher init");
        this.cipherCore.init(opmode, key, params);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.cipherCore.setCryptMode(CryptMode.fromValue((String)mode));
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.cipherCore.setPadding(padding);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        LOGGER.debug("DESCipher: cipher update");
        return this.cipherCore.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        LOGGER.debug("DESCipher: cipher update");
        return this.cipherCore.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        LOGGER.debug("DESCipher: update AAD");
        this.cipherCore.updateAAD(src, offset, len);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        byte[] aad;
        LOGGER.debug("DESCipher: update AAD");
        if (byteBuffer == null) {
            LOGGER.warn("AAD byteBuffer is null, hence cannot be updated");
            return;
        }
        int aadLength = byteBuffer.limit() - byteBuffer.position();
        if (aadLength <= 0) {
            LOGGER.warn("AAD byteBuffer is empty, hence cannot be updated");
            return;
        }
        int offset = 0;
        if (byteBuffer.hasArray()) {
            offset = byteBuffer.arrayOffset() + byteBuffer.position();
            aad = byteBuffer.array();
            byteBuffer.position(byteBuffer.limit());
        } else {
            aad = new byte[aadLength];
            byteBuffer.get(aad);
        }
        this.cipherCore.updateAAD(aad, offset, aadLength);
    }

    @Override
    protected byte[] engineWrap(Key keyToWrap) throws IllegalBlockSizeException, InvalidKeyException {
        LOGGER.debug("DESCipher: wrap key");
        return this.cipherCore.wrap(keyToWrap);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        LOGGER.debug("DESCipher: upwrap key");
        return this.cipherCore.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public static final class DesCbcNOPadding
    extends DESCipher {
        public DesCbcNOPadding() {
            super(CryptMode.CBC.toString(), "NOPADDING", CipherCore.CipherType.ONLY_SINGLE_PART);
            LOGGER.debug("AESCipher: being initialized for DES/CBC/NOPADDING");
        }
    }

    public static final class DesEcbNOPadding
    extends DESCipher {
        public DesEcbNOPadding() {
            super(CryptMode.ECB.toString(), "NOPADDING", CipherCore.CipherType.ONLY_SINGLE_PART);
            LOGGER.debug("AESCipher: being initialized for DES/ECB/NOPADDING");
        }
    }

    public static final class DesCbcPKCS5Padding
    extends DESCipher {
        public DesCbcPKCS5Padding() {
            super(CryptMode.CBC.toString(), "PKCS5PADDING", CipherCore.CipherType.SUPPORTS_MULTIPART);
            LOGGER.debug("AESCipher: being initialized for DES/CBC/PKCS5PADDING");
        }
    }

    public static final class General
    extends DESCipher {
        public General() {
            super(CryptMode.ECB.toString(), "PKCS5PADDING", CipherCore.CipherType.ONLY_SINGLE_PART);
            LOGGER.debug("DESCipher: being initialized for DES/ECB/PKCS5PADDING");
        }
    }
}

