/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsDESKey;
import com.fortanix.sdkms.jce.provider.SecurityObjectParameterSpec;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsDes;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.slf4j.LoggerFactory;

public final class DESKeyGenerator
extends KeyGeneratorSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DESKeyGenerator.class));
    private List<KeyOperations> allowedKeyOperation;
    private boolean isTransientKey = true;

    @Override
    protected void engineInit(SecureRandom random) {
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        LOGGER.debug("DES Key generator: init with params");
        if (!(params instanceof SecurityObjectParameterSpec)) {
            return;
        }
        this.allowedKeyOperation = ((SecurityObjectParameterSpec)params).getAllowedKeyOperations();
        this.isTransientKey = ((SecurityObjectParameterSpec)params).getIsTransientKey();
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        LOGGER.debug("DES Key generator: init with keysize " + keysize);
        if (keysize != 56) {
            LOGGER.logAndRaiseProviderException("Wrong key size: must be equal to 56", null);
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        LOGGER.debug("DES Key generator: generate");
        KeyObject keyObject = SdkmsDes.generateKeyForDesOperation(56, this.allowedKeyOperation, this.isTransientKey);
        return new SdkmsDESKey(keyObject);
    }
}

