/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsDESedeKey;
import com.fortanix.sdkms.jce.provider.SecurityObjectParameterSpec;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsDes;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.slf4j.LoggerFactory;

public final class DESedeKeyGenerator
extends KeyGeneratorSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(DESedeKeyGenerator.class));
    private List<KeyOperations> allowedKeyOperation;
    private boolean isTransientKey = true;

    @Override
    protected void engineInit(SecureRandom random) {
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        LOGGER.debug("DESedeKeyGenerator: init with params");
        if (params instanceof SecurityObjectParameterSpec) {
            this.allowedKeyOperation = ((SecurityObjectParameterSpec)params).getAllowedKeyOperations();
            this.isTransientKey = ((SecurityObjectParameterSpec)params).getIsTransientKey();
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        LOGGER.debug("DESedeKeyGenerator: init with keysize " + keysize);
        if (keysize != 168) {
            throw new InvalidParameterException("Wrong key size: must be equal to 168");
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        LOGGER.debug("DESedeKeyGenerator: generate");
        KeyObject keyObject = SdkmsDes.generateKeyForDesedeOperation(168, this.allowedKeyOperation, this.isTransientKey);
        return new SdkmsDESedeKey(keyObject);
    }
}

