/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.Configuration;
import com.fortanix.sdkms.jce.provider.ECPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.ECPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsSignature;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import org.slf4j.LoggerFactory;

public class Ed25519Signature
extends SignatureSpi {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(Ed25519Signature.class));
    private static final ProviderUtil.DigestAlgorithms ED25519_DIGEST_ALGO = ProviderUtil.DigestAlgorithms.SHA512;
    private final ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
    private MessageDigest messageDigest = null;
    private boolean preHashed = false;
    private ECPrivateKeyImpl privateKey;
    private ECPublicKeyImpl publicKey;

    public Ed25519Signature() {
        this(false);
    }

    public Ed25519Signature(boolean preHashed) {
        this.preHashed = preHashed;
        if (this.preHashed) {
            try {
                this.messageDigest = MessageDigest.getInstance(ED25519_DIGEST_ALGO.getKey(), Configuration.getInstance().getProviderName());
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                LOGGER.logAndRaiseProviderException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        LOGGER.debug("Ed25519Signature: verify init");
        if (!(publicKey instanceof ECPublicKeyImpl)) {
            throw new InvalidKeyException("Only ECPublicKeyImpl is supported");
        }
        this.publicKey = (ECPublicKeyImpl)publicKey;
        this.privateKey = null;
        this.resetFields();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        LOGGER.debug("Ed25519Signature: sign init");
        if (!(privateKey instanceof ECPrivateKeyImpl)) {
            throw new InvalidKeyException("Only ECPrivateKeyImpl is supported");
        }
        this.privateKey = (ECPrivateKeyImpl)privateKey;
        this.publicKey = null;
        this.resetFields();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        LOGGER.debug("Ed25519Signature: sign update");
        this.dataBuffer.write(b);
    }

    @Override
    protected void engineUpdate(byte[] bytes, int offset, int len) throws SignatureException {
        LOGGER.debug("Ed25519Signature: sign update");
        this.dataBuffer.write(bytes, offset, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        LOGGER.debug("Ed25519Signature: sign final");
        try {
            if (this.preHashed) {
                byte[] digest = this.messageDigest.digest(this.dataBuffer.toByteArray());
                byte[] byArray = SdkmsSignature.signDigest(digest, ED25519_DIGEST_ALGO.getValue(), this.privateKey.getKeyDescriptor(), null).getSignature();
                return byArray;
            }
            byte[] byArray = SdkmsSignature.signData(this.dataBuffer.toByteArray(), ED25519_DIGEST_ALGO.getValue(), this.privateKey.getKeyDescriptor(), null).getSignature();
            return byArray;
        }
        finally {
            this.resetFields();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        LOGGER.debug("Ed25519Signature: sign verify");
        try {
            if (this.preHashed) {
                byte[] digest = this.messageDigest.digest(this.dataBuffer.toByteArray());
                boolean bl = SdkmsSignature.verifyDigest(signature, digest, ED25519_DIGEST_ALGO.getValue(), this.publicKey.getKeyDescriptor(), null).getResult();
                return bl;
            }
            boolean bl = SdkmsSignature.verifyData(signature, this.dataBuffer.toByteArray(), ED25519_DIGEST_ALGO.getValue(), this.publicKey.getKeyDescriptor(), null).getResult();
            return bl;
        }
        finally {
            this.resetFields();
        }
    }

    @Override
    protected void engineSetParameter(String s, Object o) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected Object engineGetParameter(String s) throws InvalidParameterException {
        return null;
    }

    protected void resetFields() {
        if (this.messageDigest != null) {
            this.messageDigest.reset();
        }
        this.dataBuffer.reset();
    }

    public static final class Ed25519ph
    extends Ed25519Signature {
        public Ed25519ph() {
            super(true);
            LOGGER.debug("Ed25519Signature: being initialized for Ed25519ph");
        }
    }

    public static final class Ed25519
    extends Ed25519Signature {
        public Ed25519() {
            LOGGER.debug("Ed25519Signature: being initialized for Ed25519");
        }
    }
}

