/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.IPadding;
import java.io.ByteArrayOutputStream;

final class PKCS5Padding
implements IPadding {
    private int blockSize;

    public PKCS5Padding(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public void pad(ByteArrayOutputStream in) {
        int inputLength = in.toByteArray().length;
        int padLength = this.getPaddingLength(inputLength);
        byte paddingOctet = (byte)(padLength & 0xFF);
        for (int i = 0; i < padLength; ++i) {
            in.write(paddingOctet);
        }
    }

    @Override
    public byte[] unpad(byte[] in) {
        int start = 0;
        byte lastByte = in[in.length - 1];
        int padValue = lastByte & 0xFF;
        start = in.length - padValue;
        if (start < 0) {
            start = -1;
        }
        for (int i = 0; i < padValue; ++i) {
            if (in[start + i] == lastByte) continue;
            start = -1;
        }
        if (start == -1) {
            return null;
        }
        byte[] output = new byte[start];
        System.arraycopy(in, 0, output, 0, start);
        return output;
    }

    @Override
    public String getName() {
        return "PKCS5PADDING";
    }

    @Override
    public int getPaddingLength(int inputLength) {
        return this.blockSize - inputLength % this.blockSize;
    }
}

