/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.RSAPrivateKeyImpl;
import com.fortanix.sdkms.jce.provider.RSAPublicKeyImpl;
import com.fortanix.sdkms.jce.provider.SecurityObjectParameterSpec;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdKmsRsa;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.RsaEncryptionPolicy;
import com.fortanix.sdkms.v1.model.RsaSignaturePolicy;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.List;
import org.slf4j.LoggerFactory;

public class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    static final int KEY_SIZE_MIN = 1024;
    static final int KEY_SIZE_MAX = 16384;
    private static final int KEY_SIZE_DEFAULT = 1024;
    private int keySize;
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(RSAKeyPairGenerator.class));
    private List<KeyOperations> allowedKeyOperation;
    private boolean isTransientKey = true;
    private RsaEncryptionPolicy rsaEncryptionPolicy;
    private RsaSignaturePolicy rsaSignaturePolicy;
    private String groupId;

    public RSAKeyPairGenerator() {
        this.initialize(1024, null);
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        LOGGER.debug("RSAKeyPairGenerator: init using params");
        if (params instanceof SecurityObjectParameterSpec) {
            this.allowedKeyOperation = ((SecurityObjectParameterSpec)params).getAllowedKeyOperations();
            this.rsaEncryptionPolicy = ((SecurityObjectParameterSpec)params).getEncryptionPolicy();
            this.rsaSignaturePolicy = ((SecurityObjectParameterSpec)params).getSignaturePolicy();
            this.groupId = ((SecurityObjectParameterSpec)params).getGroupId();
            this.isTransientKey = ((SecurityObjectParameterSpec)params).getIsTransientKey();
            params = ((SecurityObjectParameterSpec)params).getParamSpec();
        }
        if (params == null) {
            return;
        }
        if (params instanceof RSAKeyGenParameterSpec) {
            this.keySize = ((RSAKeyGenParameterSpec)params).getKeysize();
            return;
        }
        throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec or SecurityObjectParameterSpec");
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        LOGGER.debug("RSAKeyPairGenerator: init using keysize " + keysize);
        if (1024 > keysize || keysize > 16384) {
            LOGGER.logAndRaiseProviderException("Invalid key size: " + keysize, null);
        }
        this.keySize = keysize;
    }

    @Override
    public KeyPair generateKeyPair() {
        LOGGER.debug("RSAKeyPairGenerator: generate");
        KeyObject keyObject = SdKmsRsa.generateKeyForRsaOperation(this.keySize, this.allowedKeyOperation, this.rsaEncryptionPolicy, this.rsaSignaturePolicy, this.groupId, this.isTransientKey);
        RSAPublicKeyImpl rsaPublicKey = new RSAPublicKeyImpl(keyObject);
        RSAPrivateKeyImpl rsaPrivateKey = new RSAPrivateKeyImpl(keyObject);
        return new KeyPair(rsaPublicKey, rsaPrivateKey);
    }
}

