/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.jce.provider.SdkmsCipherKey;
import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SdkmsKeyService;
import com.fortanix.sdkms.jce.provider.util.ProviderUtil;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.SobjectDescriptor;
import javax.crypto.SecretKey;
import org.slf4j.LoggerFactory;

public abstract class SdkmsSecretKey
implements SecretKey,
SdkmsCipherKey {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsSecretKey.class));
    private final SobjectDescriptor descriptor;
    protected Integer keySize;
    private byte[] encoded;
    private Boolean isExportable = null;

    public SdkmsSecretKey(SobjectDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public SdkmsSecretKey(KeyObject keyObject) {
        this.descriptor = SdkmsKeyService.getKeyDescriptor(keyObject);
        this.initFromKeyObject(keyObject);
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        if (this.isExportable == null) {
            KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
            this.initFromKeyObject(keyObject);
        }
        if (this.isExportable.booleanValue()) {
            if (this.encoded == null) {
                this.encoded = SdkmsKeyService.getKeyValue(this.descriptor);
            }
        } else {
            LOGGER.info("Trying to get key material of a non exportable key: " + ProviderUtil.toStringSobjectDescriptor(this.descriptor));
        }
        return this.encoded;
    }

    @Override
    public Integer getKeySize() {
        if (this.keySize != null) {
            return this.keySize;
        }
        KeyObject keyObject = SdkmsKeyService.getKeyObject(this.descriptor);
        this.initFromKeyObject(keyObject);
        return this.keySize;
    }

    private void initFromKeyObject(KeyObject keyObject) {
        this.keySize = keyObject.getKeySize();
        this.isExportable = keyObject.getKeyOps() != null && keyObject.getKeyOps().contains(KeyOperations.EXPORT);
        this.descriptor.setTransientKey(keyObject.getTransientKey());
        this.descriptor.setKid(keyObject.getKid());
        this.descriptor.setName(null);
    }

    @Override
    public SobjectDescriptor getKeyDescriptor() {
        return this.descriptor;
    }
}

