/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider;

import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.RsaEncryptionPolicy;
import com.fortanix.sdkms.v1.model.RsaSignaturePolicy;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;

public class SecurityObjectParameterSpec
implements AlgorithmParameterSpec {
    private List<KeyOperations> allowedKeyOperations;
    private boolean isTransientKey = true;
    private RsaEncryptionPolicy rsaEncryptionPolicy;
    private RsaSignaturePolicy rsaSignaturePolicy;
    private String groupId;
    private AlgorithmParameterSpec paramSpec;

    public SecurityObjectParameterSpec() {
    }

    public SecurityObjectParameterSpec(List<KeyOperations> allowedKeyOperations) {
        if (allowedKeyOperations == null) {
            throw new IllegalArgumentException("allowedKeyOperations is null");
        }
        this.allowedKeyOperations = allowedKeyOperations;
    }

    public SecurityObjectParameterSpec(boolean isTransientKey) {
        this.isTransientKey = isTransientKey;
    }

    public SecurityObjectParameterSpec(List<KeyOperations> allowedKeyOperations, boolean isTransientKey) {
        if (allowedKeyOperations == null) {
            throw new IllegalArgumentException("allowedKeyOperations is null");
        }
        this.allowedKeyOperations = allowedKeyOperations;
        this.isTransientKey = isTransientKey;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, boolean isTransientKey) {
        this.isTransientKey = isTransientKey;
        this.paramSpec = paramSpec;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, List<KeyOperations> allowedKeyOperations) {
        this(allowedKeyOperations);
        this.paramSpec = paramSpec;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, List<KeyOperations> allowedKeyOperations, RsaSignaturePolicy rsaSignaturePolicy) {
        this(allowedKeyOperations);
        this.rsaSignaturePolicy = rsaSignaturePolicy;
        this.paramSpec = paramSpec;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, List<KeyOperations> allowedKeyOperations, RsaSignaturePolicy rsaSignaturePolicy, boolean isTransientKey) {
        this(allowedKeyOperations);
        this.rsaSignaturePolicy = rsaSignaturePolicy;
        this.paramSpec = paramSpec;
        this.isTransientKey = isTransientKey;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy rsaEncryptionPolicy, RsaSignaturePolicy rsaSignaturePolicy, boolean isTransientKey) {
        this(allowedKeyOperations);
        this.rsaEncryptionPolicy = rsaEncryptionPolicy;
        this.rsaSignaturePolicy = rsaSignaturePolicy;
        this.paramSpec = paramSpec;
        this.isTransientKey = isTransientKey;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy rsaEncryptionPolicy, RsaSignaturePolicy rsaSignaturePolicy) {
        this(allowedKeyOperations);
        this.rsaEncryptionPolicy = rsaEncryptionPolicy;
        this.rsaSignaturePolicy = rsaSignaturePolicy;
        this.paramSpec = paramSpec;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy rsaEncryptionPolicy) {
        this(allowedKeyOperations);
        this.rsaEncryptionPolicy = rsaEncryptionPolicy;
        this.paramSpec = paramSpec;
    }

    public SecurityObjectParameterSpec(AlgorithmParameterSpec paramSpec, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy rsaEncryptionPolicy, boolean isTransientKey) {
        this(allowedKeyOperations);
        this.rsaEncryptionPolicy = rsaEncryptionPolicy;
        this.paramSpec = paramSpec;
        this.isTransientKey = isTransientKey;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setIsTransientKey(boolean isTransientKey) {
        this.isTransientKey = isTransientKey;
    }

    public AlgorithmParameterSpec getParamSpec() {
        return this.paramSpec;
    }

    public List<KeyOperations> getAllowedKeyOperations() {
        return this.allowedKeyOperations;
    }

    public boolean getIsTransientKey() {
        return this.isTransientKey;
    }

    public RsaEncryptionPolicy getEncryptionPolicy() {
        return this.rsaEncryptionPolicy;
    }

    public RsaSignaturePolicy getSignaturePolicy() {
        return this.rsaSignaturePolicy;
    }

    public String getGroupId() {
        return this.groupId;
    }
}

