/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.v1.ApiException;
import java.security.ProviderException;
import org.slf4j.Logger;

public class SDKMSLogger {
    private final Logger logger;

    public SDKMSLogger(Logger logger) {
        this.logger = logger;
    }

    public void logAndRaiseProviderException(String message, Throwable exception) throws ProviderException {
        if (exception instanceof ApiException) {
            ApiException apiException = (ApiException)exception;
            this.logger.error("Provider error: {}. API response: {}. HTTP Code: {}", new Object[]{message, apiException.getResponseBody(), apiException.getCode()});
        } else {
            this.logger.error("Provider error: " + message, exception);
        }
        throw new ProviderException(message, exception);
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void debug(String message, Throwable throwable) {
        this.logger.debug(message, throwable);
    }

    public void info(String message, Throwable throwable) {
        this.logger.info(message, throwable);
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void error(String message, Throwable throwable) {
        this.logger.error(message, throwable);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void warn(String message) {
        this.logger.warn(message);
    }

    public void warn(String message, Throwable throwable) {
        this.logger.warn(message, throwable);
    }
}

