/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.RsaEncryptionPolicy;
import com.fortanix.sdkms.v1.model.RsaOptions;
import com.fortanix.sdkms.v1.model.RsaSignaturePolicy;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class SdKmsRsa {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdKmsRsa.class));

    public static KeyObject generateKeyForRsaOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, RsaEncryptionPolicy encryptionPolicy, RsaSignaturePolicy signaturePolicy, String groupId, boolean isTransientKey) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperations != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperations);
            }
            if (groupId != null) {
                securityObjectRequest.setGroupId(groupId);
            }
            securityObjectRequest.setObjType(ObjectType.RSA);
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setKeySize(keySize);
            RsaOptions rsa = new RsaOptions();
            if (encryptionPolicy != null) {
                rsa.setEncryptionPolicy(Collections.singletonList(encryptionPolicy));
                securityObjectRequest.setRsa(rsa);
            }
            if (signaturePolicy != null) {
                rsa.setSignaturePolicy(Collections.singletonList(signaturePolicy));
                securityObjectRequest.setRsa(rsa);
            }
            securityObjectRequest.setTransient(Boolean.valueOf(isTransientKey));
            keyObject = new SecurityObjectRequest().makeGenerate(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during RSA Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }

    public static KeyObject importKeyForRsaOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, byte[] material, RsaEncryptionPolicy encryptionPolicy, RsaSignaturePolicy signaturePolicy, String groupId, String alias, boolean isTransient) {
        KeyObject keyObject = null;
        try {
            if (alias == null || alias.isEmpty()) {
                alias = UUID.randomUUID().toString();
            }
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperations != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperations);
            }
            if (groupId != null) {
                securityObjectRequest.setGroupId(groupId);
            }
            securityObjectRequest.setObjType(ObjectType.RSA);
            if (isTransient) {
                securityObjectRequest.setTransient(Boolean.valueOf(true));
            } else {
                securityObjectRequest.setName(alias);
            }
            securityObjectRequest.setKeySize(keySize);
            if (material != null) {
                securityObjectRequest.setValue(material);
            }
            RsaOptions rsa = new RsaOptions();
            if (encryptionPolicy != null) {
                rsa.setEncryptionPolicy(Arrays.asList(encryptionPolicy));
                securityObjectRequest.setRsa(rsa);
            }
            if (signaturePolicy != null) {
                rsa.setSignaturePolicy(Arrays.asList(signaturePolicy));
                securityObjectRequest.setRsa(rsa);
            }
            keyObject = new SecurityObjectRequest().makeImport(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during RSA Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

