/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class SdkmsCertificate {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsCertificate.class));

    public static KeyObject importCertificate(Certificate certificate, String objectName, String groupId) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            if (objectName != null) {
                securityObjectName = objectName;
            }
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            securityObjectRequest.setObjType(ObjectType.CERTIFICATE);
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setValue(certificate.getEncoded());
            if (groupId != null) {
                securityObjectRequest.setGroupId(groupId);
            }
            keyObject = new SecurityObjectRequest().makeImport(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during importing certificate", apiException);
        }
        catch (CertificateEncodingException e) {
            LOGGER.logAndRaiseProviderException("Certificate Encoding error", e);
        }
        return keyObject;
    }
}

