/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.SDKMSLogger;
import com.fortanix.sdkms.jce.provider.service.SecurityObjectRequest;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.model.DsaOptions;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.KeyOperations;
import com.fortanix.sdkms.v1.model.ObjectType;
import com.fortanix.sdkms.v1.model.SobjectRequest;
import java.util.List;
import java.util.UUID;
import org.slf4j.LoggerFactory;

public class SdkmsDsa {
    private static final SDKMSLogger LOGGER = new SDKMSLogger(LoggerFactory.getLogger(SdkmsDsa.class));

    public static KeyObject generateKeyForDsaOperation(Integer keySize, List<KeyOperations> allowedKeyOperations, String groupId, boolean isTransientKey, Integer subgroupSize) {
        KeyObject keyObject = null;
        try {
            String securityObjectName = UUID.randomUUID().toString();
            SobjectRequest securityObjectRequest = new SobjectRequest();
            securityObjectRequest.enabled(Boolean.valueOf(true));
            if (allowedKeyOperations != null) {
                securityObjectRequest.setKeyOps(allowedKeyOperations);
            }
            if (groupId != null) {
                securityObjectRequest.setGroupId(groupId);
            }
            securityObjectRequest.setObjType(ObjectType.DSA);
            securityObjectRequest.setName(securityObjectName);
            securityObjectRequest.setKeySize(keySize);
            DsaOptions dsa = new DsaOptions();
            if (subgroupSize != null) {
                dsa.setSubgroupSize(subgroupSize);
                securityObjectRequest.setDsa(dsa);
            }
            securityObjectRequest.setTransient(Boolean.valueOf(isTransientKey));
            keyObject = new SecurityObjectRequest().makeGenerate(securityObjectRequest);
        }
        catch (ApiException apiException) {
            LOGGER.logAndRaiseProviderException("Error during DSA Key generation keySize : " + keySize, apiException);
        }
        return keyObject;
    }
}

