/*
 * Decompiled with CFR 0.152.
 */
package com.fortanix.sdkms.jce.provider.service;

import com.fortanix.sdkms.jce.provider.service.ApiClientSetup;
import com.fortanix.sdkms.jce.provider.service.ISdkmsCommand;
import com.fortanix.sdkms.v1.ApiException;
import com.fortanix.sdkms.v1.api.SecurityObjectsApi;
import com.fortanix.sdkms.v1.model.KeyObject;
import com.fortanix.sdkms.v1.model.PersistTransientKeyRequest;
import com.fortanix.sdkms.v1.model.SobjectRequest;

public class SecurityObjectRequest {
    public KeyObject makeGenerate(final SobjectRequest request) throws ApiException {
        return (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

            @Override
            public Object execute() throws ApiException {
                return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).generateSecurityObject(request);
            }

            @Override
            public String getDescription() {
                return "GenerateSecurityObject";
            }
        });
    }

    public KeyObject makeImport(final SobjectRequest request) throws ApiException {
        return (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

            @Override
            public Object execute() throws ApiException {
                return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).importSecurityObject(request);
            }

            @Override
            public String getDescription() {
                return "ImportSecurityObject";
            }
        });
    }

    public KeyObject makeUpdate(final String keyId, final SobjectRequest request) throws ApiException {
        return (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

            @Override
            public Object execute() throws ApiException {
                return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).updateSecurityObject(keyId, request);
            }

            @Override
            public String getDescription() {
                return "UpdateSecurityObject";
            }
        });
    }

    public KeyObject persistTransient(final PersistTransientKeyRequest request) throws ApiException {
        return (KeyObject)ApiClientSetup.getInstance().ensureValidSession(new ISdkmsCommand(){

            @Override
            public Object execute() throws ApiException {
                return new SecurityObjectsApi(ApiClientSetup.getInstance().getApiClient()).persistSecurityObject(request);
            }

            @Override
            public String getDescription() {
                return "PersistSecurityObject";
            }
        });
    }
}

