/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import jnr.constants.platform.ProtocolFamily;
import jnr.ffi.Platform;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;

abstract class SockAddrUnix
extends Struct {
    public static final int ADDR_LENGTH = 108;
    public static final int HEADER_LENGTH = 2;

    protected abstract Struct.UTF8String getPathField();

    protected abstract Struct.NumberField getFamilyField();

    SockAddrUnix() {
        super(Runtime.getSystemRuntime());
    }

    final void setFamily(ProtocolFamily family) {
        this.getFamilyField().set((Number)family.intValue());
    }

    final ProtocolFamily getFamily() {
        return ProtocolFamily.valueOf((long)this.getFamilyField().intValue());
    }

    void setPath(String path) {
        this.getPathField().set(path);
    }

    final String getPath() {
        return this.getPathField().get();
    }

    int getMaximumLength() {
        return 2 + this.getPathField().length();
    }

    int length() {
        return 2 + SockAddrUnix.strlen(this.getPathField());
    }

    int getHeaderLength() {
        return 2;
    }

    static SockAddrUnix create() {
        return Platform.getNativePlatform().isBSD() ? new BSDSockAddrUnix() : new DefaultSockAddrUnix();
    }

    private static final int strlen(Struct.UTF8String str) {
        int end = str.getMemory().indexOf(str.offset(), (byte)0);
        return end >= 0 ? end : str.length();
    }

    static final class DefaultSockAddrUnix
    extends SockAddrUnix {
        public final Struct.Unsigned16 sun_family = new Struct.Unsigned16((Struct)this);
        public final Struct.UTF8String sun_addr = new Struct.UTF8String((Struct)this, 108);

        DefaultSockAddrUnix() {
        }

        @Override
        protected final Struct.UTF8String getPathField() {
            return this.sun_addr;
        }

        @Override
        protected final Struct.NumberField getFamilyField() {
            return this.sun_family;
        }
    }

    static final class BSDSockAddrUnix
    extends SockAddrUnix {
        public final Struct.Unsigned8 sun_len = new Struct.Unsigned8((Struct)this);
        public final Struct.Unsigned8 sun_family = new Struct.Unsigned8((Struct)this);
        public final Struct.UTF8String sun_addr = new Struct.UTF8String((Struct)this, 108);

        BSDSockAddrUnix() {
        }

        @Override
        public void setPath(String path) {
            super.setPath(path);
            this.sun_len.set((Number)path.length());
        }

        @Override
        protected final Struct.UTF8String getPathField() {
            return this.sun_addr;
        }

        @Override
        protected final Struct.NumberField getFamilyField() {
            return this.sun_family;
        }
    }
}

