/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.apache.commons.io.IOUtils;

public abstract class CucumberResultsCommon {
    public static final int CHART_WIDTH = 450;
    public static final int CHART_HEIGHT = 300;
    public static final int CHART_THICKNESS = 20;
    private String sourceFile;

    public final String getSourceFile() {
        return this.sourceFile;
    }

    public final void setSourceFile(String sourceFileValue) {
        this.sourceFile = sourceFileValue;
    }

    public CucumberFeatureResult[] aggregateResults(CucumberFeatureResult[] input, boolean collapse) {
        for (int i = 0; i < input.length; ++i) {
            input[i].aggregateScenarioResults(collapse);
        }
        return input;
    }

    public CucumberFeatureResult[] readFileContent(boolean aggregate) throws Exception {
        FileInputStream fis = null;
        JsonReader jr = null;
        File file = new File(this.getSourceFile());
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        fis = new FileInputStream(file);
        jr = new JsonReader((InputStream)fis, true);
        JsonObject source = (JsonObject)jr.readObject();
        Object[] objs = (Object[])source.get((Object)"@items");
        CucumberFeatureResult[] sources = new CucumberFeatureResult[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            sources[i] = new CucumberFeatureResult((JsonObject<String, Object>)((JsonObject)objs[i]));
        }
        jr.close();
        fis.close();
        sources = this.aggregateResults(sources, aggregate);
        return sources;
    }

    public <T extends CucumberFeatureResult> T[] readFileContent(Class<T> param) throws Exception {
        FileInputStream fis = null;
        JsonReader jr = null;
        File file = new File(this.getSourceFile());
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        fis = new FileInputStream(file);
        jr = new JsonReader((InputStream)fis, true);
        JsonObject source = (JsonObject)jr.readObject();
        Object[] objs = (Object[])source.get((Object)"@items");
        CucumberFeatureResult[] sources = (CucumberFeatureResult[])Array.newInstance(param, objs.length);
        for (int i = 0; i < objs.length; ++i) {
            sources[i] = (CucumberFeatureResult)param.getConstructors()[0].newInstance((JsonObject)objs[i]);
        }
        jr.close();
        fis.close();
        return sources;
    }

    public String replaceHtmlEntitiesWithCodes(String input) throws IOException {
        String output = input;
        HashMap<String, String> entitiesMap = new HashMap<String, String>();
        InputStream is = this.getClass().getResourceAsStream("/html_entities_map.txt");
        String[] result = IOUtils.toString((InputStream)is).split("\n");
        is.close();
        for (String line : result) {
            entitiesMap.put(line.split("(\\s+)")[0], line.split("(\\s+)")[1]);
        }
        for (Map.Entry entry : entitiesMap.entrySet()) {
            output = output.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return output;
    }

    private String drawPieBorders(int width, int height, int[] values, String[] labels, String[] colors, int pieVOffset, int shift) {
        double centerY;
        double centerX;
        double shiftAngle;
        double endAngle;
        double startAngle;
        int i;
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        double scale = 0.2;
        double centerScale = 3.0;
        String drawing = "";
        int accumulated = 0;
        for (i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            if (values[i] == sum) {
                shift = 0;
            }
            startAngle = Math.PI * 2 * (double)accumulated / (double)sum;
            endAngle = Math.PI * 2 * (double)(accumulated + values[i]) / (double)sum;
            shiftAngle = (startAngle + endAngle) / 2.0;
            centerX = (double)width / 3.0 + (double)shift * Math.sin(shiftAngle);
            centerY = (double)height / 3.0 - (double)shift * Math.cos(shiftAngle);
            double startX = centerX + 0.2 * (double)width * Math.sin(startAngle) + (double)shift * Math.sin(shiftAngle);
            double startY = centerY - 0.2 * (double)height * Math.cos(startAngle) - (double)shift * Math.cos(shiftAngle);
            drawing = drawing.concat(String.format("<path fill=\"%s\" stroke-width=\"1\" stroke=\"%s\" d=\"M%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f \"></path>", colors[i], colors[i], centerX, centerY + (double)pieVOffset, startX, startY + (double)pieVOffset, startX, startY, centerX, centerY, centerX, centerY + (double)pieVOffset));
            accumulated += values[i];
        }
        accumulated = 0;
        for (i = 0; i < values.length; ++i) {
            startAngle = Math.PI * 2 * (double)accumulated / (double)sum;
            endAngle = Math.PI * 2 * (double)(accumulated + values[i]) / (double)sum;
            shiftAngle = (startAngle + endAngle) / 2.0;
            centerX = (double)width / 3.0 + (double)shift * Math.sin(shiftAngle);
            centerY = (double)height / 3.0 - (double)shift * Math.cos(shiftAngle);
            double endX = 0.0;
            double endY = 0.0;
            if (i < values.length - 1) {
                endX = centerX + 0.2 * (double)width * Math.sin(endAngle) + (double)shift * Math.sin(shiftAngle);
                endY = centerY - 0.2 * (double)height * Math.cos(endAngle) - (double)shift * Math.cos(shiftAngle);
            } else {
                endX = centerX + (double)shift * Math.sin(shiftAngle);
                endY = centerY - 0.2 * (double)height - (double)shift * Math.cos(shiftAngle);
            }
            drawing = drawing.concat(String.format("<path fill=\"%s\" stroke-width=\"1\" stroke=\"%s\" d=\"M%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f L%.8f,%.8f \"></path>", colors[i], colors[i], centerX, centerY + (double)pieVOffset, endX, endY + (double)pieVOffset, endX, endY, centerX, centerY, centerX, centerY + (double)pieVOffset));
            accumulated += values[i];
        }
        return drawing;
    }

    private String drawPieLayer(int width, int height, int[] values, String[] labels, String[] colors, int pieVOffset, int shift) {
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        double scale = 0.2;
        double centerScale = 3.0;
        String drawing = "";
        int accumulated = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 0) continue;
            if (values[i] == sum) {
                shift = 0;
            }
            double startAngle = Math.PI * 2 * (double)accumulated / (double)sum;
            double endAngle = Math.PI * 2 * (double)(accumulated + values[i]) / (double)sum;
            double shiftAngle = (startAngle + endAngle) / 2.0;
            double centerX = (double)width / 3.0 + (double)shift * Math.sin(shiftAngle);
            double centerY = (double)height / 3.0 - (double)shift * Math.cos(shiftAngle);
            double radiusX = 0.2 * (double)width;
            double radiusY = 0.2 * (double)height;
            int pieParts = 5;
            for (int j = 0; j < 5; ++j) {
                double angleDiff = endAngle - startAngle;
                double startX = centerX + 0.2 * (double)width * Math.sin(startAngle + (double)j * angleDiff / 5.0) + (double)shift * Math.sin(shiftAngle);
                double startY = centerY - 0.2 * (double)height * Math.cos(startAngle + (double)j * angleDiff / 5.0) - (double)shift * Math.cos(shiftAngle);
                double endX = centerX + 0.2 * (double)width * Math.sin(startAngle + (double)(j + 1) * angleDiff / 5.0) + (double)shift * Math.sin(shiftAngle);
                double endY = centerY - 0.2 * (double)height * Math.cos(startAngle + (double)(j + 1) * angleDiff / 5.0) - (double)shift * Math.cos(shiftAngle);
                drawing = drawing.concat(String.format("<path fill=\"%s\" stroke-width=\"1\" stroke=\"%s\" d=\"M%.8f,%.8f L%.8f,%.8f A%.8f,%.8f,0,%d,1,%.8f,%.8f M%.8f,%.8f L%.8f,%.8f\"></path>", colors[i], colors[i], centerX, centerY + (double)pieVOffset, startX, startY + (double)pieVOffset, radiusX, radiusY, 0, endX, endY + (double)pieVOffset, endX, endY + (double)pieVOffset, centerX, centerY + (double)pieVOffset));
            }
            accumulated += values[i];
        }
        return drawing;
    }

    public String generatePieChart(int width, int height, int[] values, String[] labels, String[] colors, String[] shadowColors, int pieThickness, int shift) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/printable_chart.html");
        String result = IOUtils.toString((InputStream)is);
        is.close();
        int sum = 0;
        for (int value : values) {
            sum += value;
        }
        String drawing = "";
        drawing = drawing.concat(this.drawPieLayer(width, height, values, labels, shadowColors, pieThickness, shift));
        drawing = drawing.concat(this.drawPieBorders(width, height, values, labels, shadowColors, pieThickness, shift));
        drawing = drawing.concat(this.drawPieLayer(width, height, values, labels, colors, 0, shift));
        for (int i = 0; i < values.length; ++i) {
            drawing = drawing.concat(String.format("<text x=\"%d\" y=\"%d\" font-weight = \"bold\" font-size = \"14\">%.0f%% (%d) %s</text>", (int)(0.6 * (double)width) + 10, (int)(0.15 * (double)width) + 30 * i, 100.0 * (double)values[i] / (double)sum, values[i], labels[i]));
            drawing = drawing.concat(String.format("<circle cx=\"%d\" cy=\"%d\" r=\"5\" stroke=\"%s\" stroke-width=\"1\" fill=\"%s\" />", (int)(0.6 * (double)width), (int)(0.15 * (double)width) + 30 * i - 5, shadowColors[i], colors[i]));
        }
        result = result.replaceAll("__DRAWING__", drawing);
        result = result.replaceAll("__HEIGHT__", String.valueOf(height));
        result = result.replaceAll("__WIDTH__", String.valueOf(width));
        return result;
    }

    public void dumpOverviewStats(File outFile, CucumberFeatureResult[] results) {
        int[][] stats = this.getStatuses(results);
        JAXB.marshal((Object)stats, (File)outFile);
    }

    public abstract int[][] getStatuses(CucumberFeatureResult[] var1);
}

