/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.CucumberResultsCommon;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.xhtmlrenderer.simple.PDFRenderer;

public class CucumberResultsOverview
extends CucumberResultsCommon {
    private String outputDirectory;
    private String outputName;

    public final String getOutputDirectory() {
        return this.outputDirectory;
    }

    public final void setOutputDirectory(String outputDirectoryValue) {
        this.outputDirectory = outputDirectoryValue;
    }

    public final String getOutputName() {
        return this.outputName;
    }

    public final void setOutputName(String outputNameValue) {
        this.outputName = outputNameValue;
    }

    protected String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/feature-overview-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    @Override
    public int[][] getStatuses(CucumberFeatureResult[] results) {
        int[][] statuses = new int[][]{{0, 0, 0}, {0, 0, 0}};
        for (CucumberFeatureResult result : results) {
            if (result.getStatus().trim().equalsIgnoreCase("passed")) {
                int[] nArray = statuses[0];
                nArray[0] = nArray[0] + 1;
            } else if (result.getStatus().trim().equalsIgnoreCase("failed")) {
                int[] nArray = statuses[0];
                nArray[1] = nArray[1] + 1;
            } else {
                int[] nArray = statuses[0];
                nArray[2] = nArray[2] + 1;
            }
            for (CucumberScenarioResult element : result.getElements()) {
                if (element.getStatus().trim().equalsIgnoreCase("passed")) {
                    int[] nArray = statuses[1];
                    nArray[0] = nArray[0] + 1;
                    continue;
                }
                if (element.getStatus().trim().equalsIgnoreCase("failed")) {
                    int[] nArray = statuses[1];
                    nArray[1] = nArray[1] + 1;
                    continue;
                }
                int[] nArray = statuses[1];
                nArray[2] = nArray[2] + 1;
            }
        }
        return statuses;
    }

    protected String generateFeatureOverview(CucumberFeatureResult[] results) throws IOException {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", "Features Overview");
        String reportContent = "";
        reportContent = reportContent + "<h1>Features Status</h1><table><tr><th>Feature Name</th><th>Status</th><th>Passed</th><th>Failed</th><th>Undefined</th><th>Duration</th></tr>";
        for (CucumberFeatureResult result : results) {
            reportContent = reportContent + String.format("<tr class=\"%s\"><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%d</td><td>%.2fs</td></tr>", result.getStatus(), result.getName(), result.getStatus(), result.getPassed(), result.getFailed(), result.getUndefined() + result.getSkipped(), Float.valueOf(result.getDuration()));
        }
        reportContent = reportContent + "</table>";
        reportContent = reportContent + "<h1>Scenario Status</h1><table><tr><th>Feature Name</th><th>Scenario</th><th>Status</th><th>Passed</th><th>Failed</th><th>Undefined</th><th>Retries</th><th>Duration</th></tr>";
        int[][] statuses = this.getStatuses(results);
        int[] featureStatuses = statuses[0];
        int[] scenarioStatuses = statuses[1];
        for (CucumberFeatureResult result : results) {
            for (CucumberScenarioResult element : result.getElements()) {
                reportContent = reportContent + String.format("<tr class=\"%s\"><td>%s</td><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td>%.2fs</td></tr>", element.getStatus(), result.getName(), element.getName(), element.getStatus(), element.getPassed(), element.getFailed(), element.getUndefined() + element.getSkipped(), element.getRerunAttempts(), element.getDuration());
            }
        }
        reportContent = reportContent + "</table>";
        content = content.replaceAll("__REPORT__", reportContent);
        content = content.replaceAll("__FEATURE_DATA__", this.generatePieChart(450, 300, featureStatuses, new String[]{"Passed", "Failed", "Undefined"}, new String[]{"green", "red", "silver"}, new String[]{"darkgreen", "darkred", "darkgray"}, 20, 2));
        content = content.replaceAll("__SCENARIO_DATA__", this.generatePieChart(450, 300, scenarioStatuses, new String[]{"Passed", "Failed", "Undefined"}, new String[]{"green", "red", "silver"}, new String[]{"darkgreen", "darkred", "darkgray"}, 20, 2));
        return content;
    }

    public void executeOverviewReport(String reportSuffix) throws Exception {
        this.executeOverviewReport(reportSuffix, false);
    }

    public void executeOverviewReport(String reportSuffix, boolean toPdf) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent(true);
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + reportSuffix + ".html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateFeatureOverview(features));
        if (toPdf) {
            String outputFile = this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + reportSuffix + ".pdf";
            PDFRenderer.renderToPDF((File)outFile, (String)outputFile);
        }
        try {
            outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + reportSuffix + "-dump.xml");
            this.dumpOverviewStats(outFile, features);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    public void executeFeaturesOverviewReport() throws Exception {
        this.executeOverviewReport("feature-overview", false);
    }
}

