/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.DateTimeUtil;
import com.power.doc.builder.DocBuilderTemplate;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.factory.BuildTemplateFactory;
import com.power.doc.helper.JavaProjectBuilderHelper;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.template.IDocBuildTemplate;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.util.List;

public class ApiDocBuilder {
    private static final String API_EXTENSION = "Api.md";
    private static final String DATE_FORMAT = "yyyyMMddHHmm";

    public static void buildApiDoc(ApiConfig config) {
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        ApiDocBuilder.buildApiDoc(config, javaProjectBuilder);
    }

    public static void buildApiDoc(ApiConfig config, JavaProjectBuilder javaProjectBuilder) {
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        config.setAdoc(false);
        config.setParamsDataToTree(false);
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        IDocBuildTemplate docBuildTemplate = BuildTemplateFactory.getDocBuildTemplate(config.getFramework());
        List<ApiDoc> apiDocList = docBuildTemplate.getApiData(configBuilder);
        if (config.isAllInOne()) {
            String version = config.isCoverOld() ? "" : "-V" + DateTimeUtil.long2Str((long)System.currentTimeMillis(), (String)DATE_FORMAT);
            String docName = builderTemplate.allInOneDocName(config, "AllInOne" + version + ".md", ".md");
            apiDocList = docBuildTemplate.handleApiGroup(apiDocList, config);
            builderTemplate.buildAllInOne(apiDocList, config, javaProjectBuilder, "AllInOne.btl", docName);
        } else {
            builderTemplate.buildApiDoc(apiDocList, config, "ApiDoc.btl", API_EXTENSION);
            builderTemplate.buildErrorCodeDoc(config, "ErrorCodeList.btl", "ErrorCodeList.md");
            builderTemplate.buildDirectoryDataDoc(config, javaProjectBuilder, "Dictionary.btl", "Dictionary.md");
        }
    }

    public static void buildSingleApiDoc(ApiConfig config, String controllerName) {
        config.setAdoc(false);
        JavaProjectBuilder javaProjectBuilder = JavaProjectBuilderHelper.create();
        ProjectDocConfigBuilder configBuilder = new ProjectDocConfigBuilder(config, javaProjectBuilder);
        DocBuilderTemplate builderTemplate = new DocBuilderTemplate();
        builderTemplate.checkAndInit(config, false);
        builderTemplate.buildSingleApi(configBuilder, controllerName, "ApiDoc.btl", API_EXTENSION);
    }
}

