/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.navigation;

import com.graphhopper.navigation.DistanceUtils;
import com.graphhopper.navigation.VoiceInstructionConfig;
import com.graphhopper.util.Helper;
import com.graphhopper.util.TranslationMap;
import java.util.Locale;

class InitialVoiceInstructionConfig
extends VoiceInstructionConfig {
    private final int distanceDelay;
    private final int distanceForInitialStayInstruction;
    private final DistanceUtils.Unit unit;
    private final TranslationMap translationMap;

    public InitialVoiceInstructionConfig(String key, TranslationMap translationMap, Locale locale, int distanceForInitialStayInstruction, int distanceDelay, DistanceUtils.Unit unit) {
        super(key, translationMap, locale);
        this.distanceForInitialStayInstruction = distanceForInitialStayInstruction;
        this.distanceDelay = distanceDelay;
        this.unit = unit;
        this.translationMap = translationMap;
    }

    private int distanceAlongGeometry(double distanceMeter) {
        int tmpDistance = (int)(distanceMeter - (double)this.distanceDelay);
        if (this.unit == DistanceUtils.Unit.METRIC) {
            return tmpDistance / 1000 * 1000;
        }
        tmpDistance = (int)((float)tmpDistance * DistanceUtils.meterToMiles);
        return (int)Math.ceil((float)tmpDistance / DistanceUtils.meterToMiles);
    }

    private int distanceVoiceValue(double distanceInMeter) {
        if (this.unit == DistanceUtils.Unit.METRIC) {
            return (int)((float)this.distanceAlongGeometry(distanceInMeter) * DistanceUtils.meterToKilometer);
        }
        return (int)((float)this.distanceAlongGeometry(distanceInMeter) * DistanceUtils.meterToMiles);
    }

    @Override
    public VoiceInstructionConfig.VoiceInstructionValue getConfigForDistance(double distance, String turnDescription, String thenVoiceInstruction) {
        if (distance > (double)this.distanceForInitialStayInstruction) {
            int spokenDistance = this.distanceAlongGeometry(distance);
            int distanceVoiceValue = this.distanceVoiceValue(distance);
            Object continueDescription = this.translationMap.getWithFallBack(this.locale).tr("continue", new Object[0]) + " " + this.translationMap.getWithFallBack(this.locale).tr("navigate." + this.translationKey, new Object[]{distanceVoiceValue});
            continueDescription = Helper.firstBig((String)continueDescription);
            return new VoiceInstructionConfig.VoiceInstructionValue(spokenDistance, (String)continueDescription);
        }
        return null;
    }
}

