/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientCloudConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientMetricsConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.config.ClientSqlConfig;
import com.hazelcast.client.config.ClientTpcConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ConnectionRetryConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.CredentialsFactoryConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.KerberosIdentityConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.config.security.UsernamePasswordIdentityConfig;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.internal.config.AliasedDiscoveryConfigUtils;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.spring.config.ConfigFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastClientBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        AbstractBeanDefinition bean = springXmlBuilder.handleClient(element);
        this.registerCPSubsystemBean(element, parserContext);
        return bean;
    }

    private void registerCPSubsystemBean(Element element, ParserContext parserContext) {
        String instanceBeanRef = element.getAttribute("id");
        BeanDefinitionBuilder cpBeanDefBuilder = BeanDefinitionBuilder.rootBeanDefinition(CPSubsystem.class);
        cpBeanDefBuilder.setFactoryMethodOnBean("getCPSubsystem", instanceBeanRef);
        cpBeanDefBuilder.setLazyInit(true);
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)cpBeanDefBuilder.getBeanDefinition(), instanceBeanRef + "@cp-subsystem");
        this.registerBeanDefinition(holder, parserContext.getRegistry());
    }

    public static class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private static final int INITIAL_CAPACITY = 10;
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;
        private final ManagedMap<String, BeanDefinition> nearCacheConfigMap = new ManagedMap();
        private final ManagedMap<String, BeanDefinition> flakeIdGeneratorConfigMap = new ManagedMap();
        private final ManagedMap<String, BeanDefinition> reliableTopicConfigMap = new ManagedMap();

        SpringXmlBuilder(ParserContext parserContext) {
            this(parserContext, BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class).setFactoryMethod("newHazelcastClient").setDestroyMethodName("shutdown"));
        }

        public SpringXmlBuilder(ParserContext parserContext, BeanDefinitionBuilder builder) {
            this.parserContext = parserContext;
            this.builder = builder;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConfigFactory.class, (String)"newClientConfig");
            this.configBuilder.addPropertyValue("nearCacheConfigMap", this.nearCacheConfigMap);
            this.configBuilder.addPropertyValue("flakeIdGeneratorConfigMap", this.flakeIdGeneratorConfigMap);
            this.configBuilder.addPropertyValue("reliableTopicConfigMap", this.reliableTopicConfigMap);
        }

        public AbstractBeanDefinition handleClient(Node rootNode) {
            AbstractBeanDefinition configBean = this.createConfigBean(rootNode);
            this.builder.addConstructorArgValue((Object)configBean);
            return this.builder.getBeanDefinition();
        }

        AbstractBeanDefinition createConfigBean(Node rootNode) {
            this.handleCommonBeanAttributes(rootNode, this.builder, this.parserContext);
            for (Node node : DomConfigHelper.childElements((Node)rootNode)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                if ("cluster-name".equals(nodeName)) {
                    this.configBuilder.addPropertyValue("clusterName", (Object)this.getTextContent(node));
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node, this.configBuilder);
                    continue;
                }
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                    this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("serialization".equals(nodeName)) {
                    this.handleSerialization(node);
                    continue;
                }
                if ("proxy-factories".equals(nodeName)) {
                    ManagedList list = this.parseProxyFactories(node, ProxyFactoryConfig.class);
                    this.configBuilder.addPropertyValue("proxyFactoryConfigs", (Object)list);
                    continue;
                }
                if ("load-balancer".equals(nodeName)) {
                    this.handleLoadBalancer(node);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCache(node);
                    continue;
                }
                if ("spring-aware".equals(nodeName)) {
                    this.handleSpringAware();
                    continue;
                }
                if ("query-caches".equals(nodeName)) {
                    ManagedMap queryCaches = this.getQueryCaches(node);
                    this.configBuilder.addPropertyValue("queryCacheConfigs", (Object)queryCaches);
                    continue;
                }
                if ("connection-strategy".equals(nodeName)) {
                    this.handleConnectionStrategy(node);
                    continue;
                }
                if ("user-code-deployment".equals(nodeName)) {
                    this.handleUserCodeDeployment(node);
                    continue;
                }
                if ("flake-id-generator".equals(nodeName)) {
                    this.handleFlakeIdGenerator(node);
                    continue;
                }
                if ("reliable-topic".equals(nodeName)) {
                    this.handleReliableTopic(node);
                    continue;
                }
                if ("security".equals(nodeName)) {
                    this.handleSecurity(node);
                    continue;
                }
                if ("instance-name".equals(nodeName)) {
                    this.configBuilder.addPropertyValue("instanceName", (Object)this.getTextContent(node));
                    continue;
                }
                if ("labels".equals(nodeName)) {
                    this.handleLabels(node);
                    continue;
                }
                if ("backup-ack-to-client-enabled".equals(nodeName)) {
                    this.configBuilder.addPropertyValue("backupAckToClientEnabled", (Object)this.getTextContent(node));
                    continue;
                }
                if ("metrics".equals(nodeName)) {
                    this.handleMetrics(node);
                    continue;
                }
                if ("instance-tracking".equals(nodeName)) {
                    this.handleInstanceTracking(node);
                    continue;
                }
                if ("native-memory".equals(nodeName)) {
                    this.handleNativeMemory(node);
                    continue;
                }
                if ("sql".equals(nodeName)) {
                    this.handleSql(node);
                    continue;
                }
                if (!"tpc".equals(nodeName)) continue;
                this.handleTpc(node);
            }
            return this.configBuilder.getBeanDefinition();
        }

        private void handleSecurity(Node node) {
            BeanDefinitionBuilder securityConfigBuilder = this.createBeanBuilder(ClientSecurityConfig.class);
            AbstractBeanDefinition beanDefinition = securityConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, securityConfigBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder configBuilder;
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("credentials-factory".equals(nodeName)) {
                    this.handleCredentialsFactory(child, securityConfigBuilder);
                    continue;
                }
                if ("username-password".equals(nodeName)) {
                    configBuilder = this.createBeanBuilder(UsernamePasswordIdentityConfig.class).addConstructorArgValue((Object)this.getAttribute(child, "username")).addConstructorArgValue((Object)this.getAttribute(child, "password"));
                    securityConfigBuilder.addPropertyValue("UsernamePasswordIdentityConfig", (Object)configBuilder.getBeanDefinition());
                    continue;
                }
                if ("token".equals(nodeName)) {
                    configBuilder = this.createBeanBuilder(TokenIdentityConfig.class).addConstructorArgValue((Object)TokenEncoding.getTokenEncoding((String)this.getAttribute(child, "encoding"))).addConstructorArgValue((Object)this.getTextContent(child));
                    securityConfigBuilder.addPropertyValue("TokenIdentityConfig", (Object)configBuilder.getBeanDefinition());
                    continue;
                }
                if ("kerberos".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, KerberosIdentityConfig.class, "KerberosIdentityConfig", securityConfigBuilder, new String[0]);
                    continue;
                }
                if ("credentials-ref".equals(nodeName)) {
                    securityConfigBuilder.addPropertyReference("credentials", this.getTextContent(child));
                    continue;
                }
                if (!"realms".equals(nodeName)) continue;
                this.handleRealms(child, securityConfigBuilder);
            }
            this.configBuilder.addPropertyValue("securityConfig", (Object)beanDefinition);
        }

        void handleCredentialsFactory(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder credentialsConfigBuilder = this.createBeanBuilder(CredentialsFactoryConfig.class);
            AbstractBeanDefinition beanDefinition = credentialsConfigBuilder.getBeanDefinition();
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            credentialsConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                credentialsConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create CredentialsFactory!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, credentialsConfigBuilder);
                break;
            }
            securityConfigBuilder.addPropertyValue("credentialsFactoryConfig", (Object)beanDefinition);
        }

        private void handleConnectionStrategy(Node node) {
            BeanDefinitionBuilder clientConnectionStrategyConfig = this.createBeanBuilder(ClientConnectionStrategyConfig.class);
            this.fillAttributeValues(node, clientConnectionStrategyConfig, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"connection-retry".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, ConnectionRetryConfig.class, "ConnectionRetryConfig", clientConnectionStrategyConfig, new String[0]);
            }
            this.configBuilder.addPropertyValue("connectionStrategyConfig", (Object)clientConnectionStrategyConfig.getBeanDefinition());
        }

        private void handleUserCodeDeployment(Node node) {
            BeanDefinitionBuilder userCodeDeploymentConfig = this.createBeanBuilder(ClientUserCodeDeploymentConfig.class);
            ArrayList<String> jarPaths = new ArrayList<String>(10);
            ArrayList<String> classNames = new ArrayList<String>(10);
            this.fillAttributeValues(node, userCodeDeploymentConfig, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName1;
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("jarpaths".equals(nodeName)) {
                    for (Node child1 : DomConfigHelper.childElements((Node)child)) {
                        nodeName1 = DomConfigHelper.cleanNodeName((Node)child1);
                        if (!"jarpath".equals(nodeName1)) continue;
                        jarPaths.add(this.getTextContent(child1));
                    }
                    continue;
                }
                if (!"classnames".equals(nodeName)) continue;
                for (Node child1 : DomConfigHelper.childElements((Node)child)) {
                    nodeName1 = DomConfigHelper.cleanNodeName((Node)child1);
                    if (!"classname".equals(nodeName1)) continue;
                    classNames.add(this.getTextContent(child1));
                }
            }
            userCodeDeploymentConfig.addPropertyValue("jarPaths", jarPaths);
            userCodeDeploymentConfig.addPropertyValue("classNames", classNames);
            this.configBuilder.addPropertyValue("userCodeDeploymentConfig", (Object)userCodeDeploymentConfig.getBeanDefinition());
        }

        private void handleNetwork(Node node) {
            BeanDefinitionBuilder clientNetworkConfig = this.createBeanBuilder(ClientNetworkConfig.class);
            ArrayList<String> members = new ArrayList<String>(10);
            this.fillAttributeValues(node, clientNetworkConfig, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if ("member".equals(nodeName)) {
                    members.add(this.getTextContent(child));
                    continue;
                }
                if ("socket-options".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, SocketOptions.class, "socketOptions", clientNetworkConfig, new String[0]);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, clientNetworkConfig);
                    continue;
                }
                if (AliasedDiscoveryConfigUtils.supports((String)nodeName)) {
                    this.handleAliasedDiscoveryStrategy(child, clientNetworkConfig, nodeName);
                    continue;
                }
                if ("discovery-strategies".equals(nodeName)) {
                    this.handleDiscoveryStrategies(child, clientNetworkConfig);
                    continue;
                }
                if ("auto-detection".equals(nodeName)) {
                    this.handleAutoDetection(child, clientNetworkConfig);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, clientNetworkConfig);
                    continue;
                }
                if ("icmp-ping".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, ClientIcmpPingConfig.class, "clientIcmpPingConfig", clientNetworkConfig, new String[0]);
                    continue;
                }
                if (!"hazelcast-cloud".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, ClientCloudConfig.class, "cloudConfig", clientNetworkConfig, new String[0]);
            }
            clientNetworkConfig.addPropertyValue("addresses", members);
            this.configBuilder.addPropertyValue("networkConfig", (Object)clientNetworkConfig.getBeanDefinition());
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        private void handleLoadBalancer(Node node) {
            String type = this.getAttribute(node, "type");
            if ("random".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RandomLB());
            } else if ("round-robin".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RoundRobinLB());
            } else if ("custom".equals(type)) {
                NamedNodeMap attributes = node.getAttributes();
                Node classNameNode = attributes.getNamedItem("class-name");
                String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
                Node implNode = attributes.getNamedItem("implementation");
                String implementation = implNode != null ? this.getTextContent(implNode) : null;
                Assert.isTrue((boolean)(className != null ^ implementation != null), (String)"Exactly one of 'class-name' or 'implementation' attributes is required to create LoadBalancer!");
                if (className != null) {
                    BeanDefinitionBuilder loadBalancerBeanDefinition = this.createBeanBuilder(className);
                    this.configBuilder.addPropertyValue("loadBalancer", (Object)loadBalancerBeanDefinition.getBeanDefinition());
                } else {
                    this.configBuilder.addPropertyReference("loadBalancer", implementation);
                }
            }
        }

        private void handleNearCache(Node node) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            this.fillAttributeValues(node, nearCacheConfigBuilder, new String[0]);
            for (Node childNode : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)childNode);
                if ("eviction".equals(nodeName)) {
                    this.handleEvictionConfig(childNode, nearCacheConfigBuilder, true);
                    continue;
                }
                if (!"preloader".equals(nodeName)) continue;
                this.handlePreloaderConfig(childNode, nearCacheConfigBuilder);
            }
            String name = this.getAttribute(node, "name");
            this.nearCacheConfigMap.put((Object)name, (Object)nearCacheConfigBuilder.getBeanDefinition());
        }

        private void handleFlakeIdGenerator(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(ClientFlakeIdGeneratorConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            String name = this.getAttribute(node, "name");
            this.flakeIdGeneratorConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleReliableTopic(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(ClientReliableTopicConfig.class);
            String name = this.getAttribute(node, "name");
            this.fillValues(node, configBuilder, new String[0]);
            this.reliableTopicConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleEvictionConfig(Node node, BeanDefinitionBuilder configBuilder, boolean isNearCache) {
            configBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node, isNearCache, false));
        }

        private void handlePreloaderConfig(Node node, BeanDefinitionBuilder configBuilder) {
            configBuilder.addPropertyValue("preloaderConfig", (Object)this.getPreloaderConfig(node));
        }

        private ManagedMap getQueryCaches(Node childNode) {
            ManagedMap queryCaches = new ManagedMap();
            for (Node queryCacheNode : DomConfigHelper.childElements((Node)childNode)) {
                this.parseQueryCache((ManagedMap<String, ManagedMap<String, BeanDefinition>>)queryCaches, queryCacheNode);
            }
            return queryCaches;
        }

        private void parseQueryCache(ManagedMap<String, ManagedMap<String, BeanDefinition>> queryCaches, Node queryCacheNode) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(QueryCacheConfig.class);
            NamedNodeMap attributes = queryCacheNode.getAttributes();
            String mapName = this.getTextContent(attributes.getNamedItem("map-name"));
            String cacheName = this.getTextContent(attributes.getNamedItem("name"));
            for (Node node : DomConfigHelper.childElements((Node)queryCacheNode)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)node);
                String textContent = this.getTextContent(node);
                this.parseQueryCacheInternal(builder, node, nodeName, textContent);
            }
            builder.addPropertyValue("name", (Object)cacheName);
            ManagedMap configMap = (ManagedMap)queryCaches.get((Object)mapName);
            if (configMap == null) {
                configMap = new ManagedMap();
                queryCaches.put((Object)mapName, (Object)configMap);
            }
            configMap.put((Object)cacheName, (Object)builder.getBeanDefinition());
        }

        private void parseQueryCacheInternal(BeanDefinitionBuilder builder, Node node, String nodeName, String textContent) {
            if ("predicate".equals(nodeName)) {
                BeanDefinitionBuilder predicateBuilder = this.getPredicate(node, textContent);
                builder.addPropertyValue("predicateConfig", (Object)predicateBuilder.getBeanDefinition());
            } else if ("entry-listeners".equals(nodeName)) {
                ManagedList<BeanDefinition> listeners = this.getEntryListeners(node);
                builder.addPropertyValue("entryListenerConfigs", listeners);
            } else if ("include-value".equals(nodeName)) {
                builder.addPropertyValue("includeValue", (Object)textContent);
            } else if ("batch-size".equals(nodeName)) {
                builder.addPropertyValue("batchSize", (Object)textContent);
            } else if ("buffer-size".equals(nodeName)) {
                builder.addPropertyValue("bufferSize", (Object)textContent);
            } else if ("delay-seconds".equals(nodeName)) {
                builder.addPropertyValue("delaySeconds", (Object)textContent);
            } else if ("in-memory-format".equals(nodeName)) {
                String value = textContent.trim();
                builder.addPropertyValue("inMemoryFormat", (Object)InMemoryFormat.valueOf((String)StringUtil.upperCaseInternal((String)value)));
            } else if ("coalesce".equals(nodeName)) {
                builder.addPropertyValue("coalesce", (Object)textContent);
            } else if ("populate".equals(nodeName)) {
                builder.addPropertyValue("populate", (Object)textContent);
            } else if ("serialize-keys".equals(nodeName)) {
                builder.addPropertyValue("serializeKeys", (Object)textContent);
            } else if ("indexes".equals(nodeName)) {
                ManagedList<BeanDefinition> indexes = this.getIndexes(node);
                builder.addPropertyValue("indexConfigs", indexes);
            } else if ("eviction".equals(nodeName)) {
                builder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node, false, false));
            }
        }

        private BeanDefinitionBuilder getPredicate(Node node, String textContent) {
            BeanDefinitionBuilder predicateBuilder = this.createBeanBuilder(PredicateConfig.class);
            String predicateType = this.getTextContent(node.getAttributes().getNamedItem("type"));
            if ("sql".equals(predicateType)) {
                predicateBuilder.addPropertyValue("sql", (Object)textContent);
            } else if ("class-name".equals(predicateType)) {
                predicateBuilder.addPropertyValue("className", (Object)textContent);
            }
            return predicateBuilder;
        }

        private ManagedList<BeanDefinition> getIndexes(Node node) {
            ManagedList indexes = new ManagedList();
            for (Node indexNode : DomConfigHelper.childElements((Node)node)) {
                this.handleIndex((ManagedList<BeanDefinition>)indexes, indexNode);
            }
            return indexes;
        }

        private ManagedList<BeanDefinition> getEntryListeners(Node node) {
            ManagedList listeners = new ManagedList();
            String implementationAttr = "implementation";
            for (Node listenerNode : DomConfigHelper.childElements((Node)node)) {
                BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(EntryListenerConfig.class);
                this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                if (implementationNode != null) {
                    listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                }
                listeners.add((Object)listenerConfBuilder.getBeanDefinition());
            }
            return listeners;
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }

        private void handleLabels(Node node) {
            ManagedList labels = new ManagedList();
            for (Node n : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)n);
                if (!"label".equals(name)) continue;
                String label = this.getTextContent(n);
                labels.add((Object)label);
            }
            this.configBuilder.addPropertyValue("labels", (Object)labels);
        }

        private void handleInstanceTracking(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(InstanceTrackingConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String name = DomConfigHelper.cleanNodeName((Node)child);
                if ("file-name".equals(name)) {
                    configBuilder.addPropertyValue("fileName", (Object)this.getTextContent(child));
                    continue;
                }
                if (!"format-pattern".equals(name)) continue;
                configBuilder.addPropertyValue("formatPattern", (Object)this.getTextContent(child));
            }
            this.configBuilder.addPropertyValue("instanceTrackingConfig", (Object)configBuilder.getBeanDefinition());
        }

        private void handleMetrics(Node node) {
            BeanDefinitionBuilder metricsConfigBuilder = this.createBeanBuilder(ClientMetricsConfig.class);
            this.fillValues(node, metricsConfigBuilder, "jmx");
            Node attrEnabled = node.getAttributes().getNamedItem("enabled");
            metricsConfigBuilder.addPropertyValue("enabled", (Object)this.getTextContent(attrEnabled));
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"jmx".equals(nodeName)) continue;
                BeanDefinitionBuilder metricsJmxConfigBuilder = this.createBeanBuilder(MetricsJmxConfig.class);
                this.fillValues(child, metricsJmxConfigBuilder, new String[0]);
                metricsConfigBuilder.addPropertyValue("jmxConfig", (Object)metricsJmxConfigBuilder.getBeanDefinition());
            }
            this.configBuilder.addPropertyValue("metricsConfig", (Object)metricsConfigBuilder.getBeanDefinition());
        }

        private void handleRealms(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            ManagedMap realms = new ManagedMap();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"realm".equals(nodeName)) continue;
                realms.put((Object)this.getAttribute(child, "name"), (Object)this.handleRealm(child, securityConfigBuilder));
            }
            securityConfigBuilder.addPropertyValue("realmConfigs", (Object)realms);
        }

        private AbstractBeanDefinition handleRealm(Node node, BeanDefinitionBuilder securityConfigBuilder) {
            BeanDefinitionBuilder realmConfigBuilder = this.createBeanBuilder(RealmConfig.class);
            AbstractBeanDefinition beanDefinition = realmConfigBuilder.getBeanDefinition();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"authentication".equals(nodeName)) continue;
                this.handleAuthentication(child, realmConfigBuilder);
            }
            return beanDefinition;
        }

        private void handleAuthentication(Node node, BeanDefinitionBuilder realmConfigBuilder) {
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"jaas".equals(nodeName)) continue;
                this.handleLoginModules(child, realmConfigBuilder);
            }
        }

        private void handleLoginModules(Node node, BeanDefinitionBuilder realmConfigBuilder) {
            BeanDefinitionBuilder jaasConfigBuilder = this.createBeanBuilder(JaasAuthenticationConfig.class);
            AbstractBeanDefinition beanDefinition = jaasConfigBuilder.getBeanDefinition();
            ManagedList lms = new ManagedList();
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"login-module".equals(nodeName)) continue;
                this.handleLoginModule(child, (List<BeanDefinition>)lms);
            }
            jaasConfigBuilder.addPropertyValue("loginModuleConfigs", (Object)lms);
            realmConfigBuilder.addPropertyValue("jaasAuthenticationConfig", (Object)beanDefinition);
        }

        private void handleLoginModule(Node node, List<BeanDefinition> list) {
            BeanDefinitionBuilder lmConfigBuilder = this.createBeanBuilder(LoginModuleConfig.class);
            AbstractBeanDefinition beanDefinition = lmConfigBuilder.getBeanDefinition();
            this.fillAttributeValues(node, lmConfigBuilder, "class-name", "implementation");
            NamedNodeMap attributes = node.getAttributes();
            Node classNameNode = attributes.getNamedItem("class-name");
            String className = classNameNode != null ? this.getTextContent(classNameNode) : null;
            Node implNode = attributes.getNamedItem("implementation");
            String implementation = implNode != null ? this.getTextContent(implNode) : null;
            lmConfigBuilder.addPropertyValue("className", (Object)className);
            if (implementation != null) {
                lmConfigBuilder.addPropertyReference("implementation", implementation);
            }
            Assert.isTrue((className != null || implementation != null ? 1 : 0) != 0, (String)"One of 'class-name' or 'implementation' attributes is required to create LoginModule!");
            for (Node child : DomConfigHelper.childElements((Node)node)) {
                String nodeName = DomConfigHelper.cleanNodeName((Node)child);
                if (!"properties".equals(nodeName)) continue;
                this.handleProperties(child, lmConfigBuilder);
                break;
            }
            list.add((BeanDefinition)beanDefinition);
        }

        private void handleSql(Node node) {
            BeanDefinitionBuilder sqlConfigBuilder = this.createBeanBuilder(ClientSqlConfig.class);
            this.fillValues(node, sqlConfigBuilder, new String[0]);
            this.configBuilder.addPropertyValue("sqlConfig", (Object)sqlConfigBuilder.getBeanDefinition());
        }

        private void handleTpc(Node node) {
            BeanDefinitionBuilder tpcConfigBuilder = this.createBeanBuilder(ClientTpcConfig.class);
            this.fillAttributeValues(node, tpcConfigBuilder, new String[0]);
            this.configBuilder.addPropertyValue("tpcConfig", (Object)tpcConfigBuilder.getBeanDefinition());
        }
    }
}

