/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Announcer<T extends EventListener> {
    private final T proxy;
    private final List<T> listeners = new CopyOnWriteArrayList<T>();

    public static <T extends EventListener> Announcer<T> to(Class<? extends T> listenerType) {
        return new Announcer<T>(listenerType);
    }

    public Announcer(Class<? extends T> listenerType) {
        this.proxy = (EventListener)listenerType.cast(Proxy.newProxyInstance(listenerType.getClassLoader(), new Class[]{listenerType}, (aProxy, method, args) -> {
            this.announce(method, args);
            return null;
        }));
    }

    public void addListener(T listener) {
        Preconditions.checkNotNull(listener, (Object)"Cannot add a null listener.");
        this.listeners.add(listener);
    }

    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    public T announce() {
        return this.proxy;
    }

    public List<T> listeners() {
        return this.listeners;
    }

    private void announce(Method m, Object[] args) {
        try {
            for (EventListener listener : this.listeners) {
                m.invoke((Object)listener, args);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("could not invoke listener", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UnsupportedOperationException("listener threw exception", cause);
        }
    }
}

