/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.hotels.styx.api.HttpCookieAttribute;
import java.util.Collection;
import java.util.Objects;

public final class HttpCookie {
    private static final Joiner JOINER_ON_SEMI_COLON_AND_SPACE = Joiner.on((String)"; ");
    private final String name;
    private final String value;
    private final int hashCode;
    private final Iterable<HttpCookieAttribute> attributes;

    private HttpCookie(String name, String value, Iterable<HttpCookieAttribute> attributes) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name cannot be null or empty");
        Preconditions.checkNotNull((Object)value, (Object)"value cannot be null");
        this.name = name;
        this.value = value;
        this.attributes = (Iterable)Preconditions.checkNotNull(attributes);
        this.hashCode = Objects.hash(name, value, attributes);
    }

    public static HttpCookie cookie(String name, String value, HttpCookieAttribute ... attributes) {
        return new HttpCookie(name, value, HttpCookie.nonNulls(attributes));
    }

    private static <X> Collection<X> nonNulls(X ... array) {
        for (X item : array) {
            Preconditions.checkNotNull(item);
        }
        return Lists.newArrayList((Object[])array);
    }

    public static HttpCookie cookie(String name, String value, Iterable<HttpCookieAttribute> attributes) {
        return new HttpCookie(name, value, attributes);
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Iterable<HttpCookieAttribute> attributes() {
        return this.attributes;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpCookie other = (HttpCookie)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value) && Objects.equals(this.attributes, other.attributes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.name).append('=').append(this.value).append(Iterables.isEmpty(this.attributes) ? "" : "; ");
        return JOINER_ON_SEMI_COLON_AND_SPACE.appendTo(builder, this.attributes).toString();
    }
}

