/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Preconditions;
import java.util.Objects;

public final class HttpCookieAttribute {
    private static final HttpCookieAttribute SECURE = new HttpCookieAttribute("Secure", null);
    private static final HttpCookieAttribute HTTPONLY = new HttpCookieAttribute("HttpOnly", null);
    private static final String DOMAIN = "Domain";
    private static final String PATH = "Path";
    private static final String MAX_AGE = "Max-Age";
    private final String name;
    private final String value;
    private final int hashCode;

    private HttpCookieAttribute(String name, String value) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.value = value;
        this.hashCode = Objects.hash(name, value);
    }

    public static HttpCookieAttribute domain(String domain) {
        return new HttpCookieAttribute(DOMAIN, domain);
    }

    public static HttpCookieAttribute path(String path) {
        return new HttpCookieAttribute(PATH, (String)Preconditions.checkNotNull((Object)path));
    }

    public static HttpCookieAttribute maxAge(int maxAge) {
        return new HttpCookieAttribute(MAX_AGE, Integer.toString(maxAge));
    }

    public static HttpCookieAttribute secure() {
        return SECURE;
    }

    public static HttpCookieAttribute httpOnly() {
        return HTTPONLY;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HttpCookieAttribute other = (HttpCookieAttribute)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    public String toString() {
        if (this.value == null) {
            return this.name;
        }
        return this.name + "=" + this.value;
    }
}

