/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.styx.api;

import com.google.common.base.Preconditions;
import com.hotels.styx.api.HttpHeader;
import com.hotels.styx.api.HttpHeaderNames;
import com.hotels.styx.api.HttpHeaderValues;
import com.hotels.styx.api.HttpHeaders;
import com.hotels.styx.api.HttpMessage;
import com.hotels.styx.api.HttpMessageBody;
import com.hotels.styx.api.support.CookiesSupport;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.List;
import rx.Observable;

abstract class HttpMessageBuilder<SELF extends HttpMessageBuilder<SELF, MSG>, MSG extends HttpMessage> {
    protected HttpMessageBody body = HttpMessageBody.NO_BODY;
    private HttpHeaders.Builder headers;
    private HttpVersion version = HttpVersion.HTTP_1_1;

    HttpMessageBuilder() {
    }

    HttpMessageBody body() {
        return this.body;
    }

    HttpHeaders.Builder headers() {
        return this.headers;
    }

    void headers(HttpHeaders.Builder builder) {
        this.headers = builder;
    }

    HttpVersion version() {
        return this.version;
    }

    public SELF version(HttpVersion version) {
        this.version = version;
        return (SELF)this;
    }

    public SELF body(HttpMessageBody body) {
        this.body = body;
        return (SELF)this;
    }

    public SELF body(Observable<ByteBuf> content) {
        return this.body(new HttpMessageBody(content));
    }

    public SELF body(ByteBuf content) {
        this.header(HttpHeaderNames.CONTENT_LENGTH, content.readableBytes());
        return this.body((Observable<ByteBuf>)Observable.just((Object)content));
    }

    public SELF body(String content) {
        return content == null ? this.body(Unpooled.EMPTY_BUFFER) : this.body(content.getBytes());
    }

    public SELF body(byte[] content) {
        return this.body(Unpooled.copiedBuffer((byte[])content).retain());
    }

    public SELF body(ByteBuffer content) {
        return this.body(Unpooled.copiedBuffer((ByteBuffer)content));
    }

    public SELF header(CharSequence name, String value) {
        HttpMessageBuilder.checkNotCookie(name);
        this.headers.set(name, (String)Preconditions.checkNotNull((Object)value));
        return (SELF)this;
    }

    private static void checkNotCookie(CharSequence name) {
        Preconditions.checkArgument((!CookiesSupport.isCookieHeader(name.toString()) ? 1 : 0) != 0, (Object)"Cookies must be set with addCookie method");
    }

    public SELF header(CharSequence name, Object value) {
        HttpMessageBuilder.checkNotCookie(name);
        this.headers.set(name, Preconditions.checkNotNull((Object)value));
        return (SELF)this;
    }

    public SELF header(CharSequence name, Instant value) {
        HttpMessageBuilder.checkNotCookie(name);
        this.headers.set(name, (Instant)Preconditions.checkNotNull((Object)value));
        return (SELF)this;
    }

    public SELF header(CharSequence name, Iterable<?> values) {
        HttpMessageBuilder.checkNotCookie(name);
        this.headers.set(name, values);
        return (SELF)this;
    }

    public SELF headers(HttpHeader ... headers) {
        for (HttpHeader header : headers) {
            HttpMessageBuilder.checkNotCookie(header.name());
            this.headers.set((CharSequence)header.name(), header.value());
        }
        return (SELF)this;
    }

    public SELF headers(HttpHeaders headers) {
        this.headers = headers.newBuilder();
        return (SELF)this;
    }

    public SELF addHeader(CharSequence name, String value) {
        HttpMessageBuilder.checkNotCookie(name);
        this.headers.add(name, value);
        return (SELF)this;
    }

    public SELF addHeader(CharSequence name, Object value) {
        HttpMessageBuilder.checkNotCookie(name);
        this.headers.add(name, value);
        return (SELF)this;
    }

    public SELF addHeader(CharSequence name, Iterable<?> values) {
        HttpMessageBuilder.checkNotCookie(name);
        this.headers.add(name, values);
        return (SELF)this;
    }

    public SELF removeHeader(CharSequence name) {
        this.headers.remove(name);
        return (SELF)this;
    }

    public SELF chunked() {
        this.headers().add(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED);
        this.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
        return (SELF)this;
    }

    void ensureContentLengthIsValid() {
        List<String> contentLengths = this.headers().getAll(HttpHeaderNames.CONTENT_LENGTH);
        Preconditions.checkArgument((contentLengths.size() <= 1 ? 1 : 0) != 0, (String)"Duplicate Content-Length found. %s", (Object[])new Object[]{contentLengths});
        if (contentLengths.size() == 1) {
            Preconditions.checkArgument((boolean)HttpMessageBuilder.isInteger(contentLengths.get(0)), (String)"Invalid Content-Length found. %s", (Object[])new Object[]{contentLengths.get(0)});
        }
    }

    private static boolean isInteger(String contentLength) {
        try {
            Integer.parseInt(contentLength);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public abstract MSG build();
}

